/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime;

import java.util.List;
import java.util.function.Consumer;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.wildfly.swarm.spi.api.OutboundSocketBinding;
import org.wildfly.swarm.spi.api.SocketBinding;
import org.wildfly.swarm.spi.api.SocketBindingGroup;
import org.wildfly.swarm.spi.api.config.ConfigKey;
import org.wildfly.swarm.spi.api.config.ConfigView;

@ApplicationScoped
public class SocketBindingGroupConfigurer {
    private static ConfigKey ROOT = ConfigKey.of((String[])new String[]{"swarm", "network", "socket-binding-groups"});
    @Inject
    private ConfigView configView;
    @Inject
    @Any
    private Instance<SocketBindingGroup> socketBindingGroups;

    public void configure() {
        for (SocketBindingGroup each : this.socketBindingGroups) {
            this.configure(each);
        }
    }

    protected void configure(SocketBindingGroup group) {
        this.fixSocketBindings(group);
        this.fixOutboundSocketBindings(group);
    }

    protected void fixSocketBindings(SocketBindingGroup group) {
        ConfigKey key = ROOT.append(new String[]{group.name()}).append(new String[]{"socket-bindings"});
        List names = this.configView.simpleSubkeys(key);
        names.stream().map(e -> e.name()).map(name -> group.socketBindings().stream().filter(e -> e.name().equals(name)).findFirst().orElseGet(() -> {
            SocketBinding binding = new SocketBinding(name);
            group.socketBinding(binding);
            return binding;
        })).forEach(e -> this.applyConfiguration(key, (SocketBinding)e));
    }

    protected void fixOutboundSocketBindings(SocketBindingGroup group) {
        ConfigKey key = ROOT.append(new String[]{group.name()}).append(new String[]{"outbound-socket-bindings"});
        List names = this.configView.simpleSubkeys(key);
        names.stream().map(e -> e.name()).map(name -> group.outboundSocketBindings().stream().filter(e -> e.name().equals(name)).findFirst().orElseGet(() -> {
            OutboundSocketBinding binding = new OutboundSocketBinding(name);
            group.outboundSocketBinding(binding);
            return binding;
        })).forEach(e -> this.applyConfiguration(key, (OutboundSocketBinding)e));
    }

    protected void applyConfiguration(ConfigKey root, SocketBinding binding) {
        ConfigKey key = root.append(new String[]{binding.name()});
        this.applyConfiguration(key.append(new String[]{"port"}), (Object port) -> binding.port(port.toString()));
        this.applyConfiguration(key.append(new String[]{"multicast-port"}), (Object port) -> binding.multicastPort(port.toString()));
        this.applyConfiguration(key.append(new String[]{"multicast-address"}), (Object addr) -> binding.multicastAddress(addr.toString()));
        this.applyConfiguration(key.append(new String[]{"interface"}), (Object iface) -> binding.iface(iface.toString()));
    }

    protected void applyConfiguration(ConfigKey root, OutboundSocketBinding binding) {
        ConfigKey key = root.append(new String[]{binding.name()});
        this.applyConfiguration(key.append(new String[]{"remote-host"}), (Object host) -> binding.remoteHost(host.toString()));
        this.applyConfiguration(key.append(new String[]{"remote-port"}), (Object port) -> binding.remotePort(port.toString()));
    }

    protected void applyConfiguration(ConfigKey key, Consumer<Object> consumer) {
        Object value = this.configView.valueOf(key);
        if (value != null) {
            consumer.accept(value);
        }
    }
}

