/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.jar.JarFile;
import java.util.logging.LogManager;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import javax.enterprise.inject.Vetoed;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.log.ModuleLogger;
import org.jboss.modules.log.StreamModuleLogger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Domain;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ExplodedExporter;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.importer.ExplodedImporter;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.base.exporter.ExplodedExporterImpl;
import org.jboss.shrinkwrap.impl.base.exporter.zip.ZipExporterImpl;
import org.jboss.shrinkwrap.impl.base.importer.ExplodedImporterImpl;
import org.jboss.shrinkwrap.impl.base.importer.zip.ZipImporterImpl;
import org.jboss.shrinkwrap.impl.base.spec.JavaArchiveImpl;
import org.jboss.shrinkwrap.impl.base.spec.WebArchiveImpl;
import org.wildfly.swarm.bootstrap.env.ApplicationEnvironment;
import org.wildfly.swarm.bootstrap.logging.BackingLoggerManager;
import org.wildfly.swarm.bootstrap.logging.BootstrapLogger;
import org.wildfly.swarm.bootstrap.modules.BootModuleLoader;
import org.wildfly.swarm.bootstrap.performance.Performance;
import org.wildfly.swarm.cli.CommandLine;
import org.wildfly.swarm.container.DeploymentException;
import org.wildfly.swarm.container.config.ConfigViewFactory;
import org.wildfly.swarm.container.internal.Server;
import org.wildfly.swarm.container.internal.ServerBootstrap;
import org.wildfly.swarm.container.internal.WeldShutdown;
import org.wildfly.swarm.internal.OutboundSocketBindingRequest;
import org.wildfly.swarm.internal.SocketBindingRequest;
import org.wildfly.swarm.internal.SwarmMessages;
import org.wildfly.swarm.spi.api.ArtifactLookup;
import org.wildfly.swarm.spi.api.Fraction;
import org.wildfly.swarm.spi.api.OutboundSocketBinding;
import org.wildfly.swarm.spi.api.SocketBinding;
import org.wildfly.swarm.spi.api.StageConfig;
import org.wildfly.swarm.spi.api.config.ConfigView;

@Vetoed
public class Swarm {
    public static Swarm INSTANCE = null;
    private static final String BOOT_MODULE_PROPERTY = "boot.module.loader";
    public static final String APPLICATION_MODULE_NAME = "swarm.application";
    private static final String CONTAINER_MODULE_NAME = "swarm.container";
    private static final String PROJECT_STAGES_FILE = "project-stages.yml";
    private static Swarm swarm;
    private final CommandLine commandLine;
    private String[] args;
    private Server server;
    private Set<Class<?>> userComponentClasses = new HashSet();
    private List<SocketBindingRequest> socketBindings = new ArrayList<SocketBindingRequest>();
    private List<OutboundSocketBindingRequest> outboundSocketBindings = new ArrayList<OutboundSocketBindingRequest>();
    private List<Fraction> explicitlyInstalledFractions = new ArrayList<Fraction>();
    private ConfigViewFactory configView;
    private Optional<URL> xmlConfig = Optional.empty();
    private List<URL> configs = new ArrayList<URL>();
    private List<String> profiles = new ArrayList<String>();
    private boolean debugBootstrap;
    private boolean isConstructing = true;

    public Swarm() throws Exception {
        this(Boolean.getBoolean("swarm.debug.bootstrap"));
    }

    public Swarm(boolean debugBootstrap) throws Exception {
        this(debugBootstrap, new String[0]);
    }

    public Swarm(String ... args) throws Exception {
        this(false, args);
    }

    public Swarm(boolean debugBootstrap, String ... args) throws Exception {
        this(debugBootstrap, (Properties)null, (Map<String, String>)null, args);
    }

    public Swarm(Properties properties, String ... args) throws Exception {
        this(false, properties, (Map<String, String>)null, args);
    }

    public Swarm(boolean debug, Properties properties, String ... args) throws Exception {
        this(debug, properties, (Map<String, String>)null, args);
    }

    public Swarm(Properties properties, Map<String, String> environment, String ... args) throws Exception {
        this(false, properties, environment, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Swarm(boolean debugBootstrap, Properties properties, Map<String, String> environment, String ... args) throws Exception {
        if (System.getProperty(BOOT_MODULE_PROPERTY) == null) {
            System.setProperty(BOOT_MODULE_PROPERTY, BootModuleLoader.class.getName());
        }
        if (debugBootstrap) {
            Module.setModuleLogger((ModuleLogger)new StreamModuleLogger(System.err));
        }
        this.setArgs(args);
        this.debugBootstrap = debugBootstrap;
        try {
            Module loggingModule = Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)"org.wildfly.swarm.logging", (String)"runtime"));
            ClassLoader originalCl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader((ClassLoader)loggingModule.getClassLoader());
                System.setProperty("java.util.logging.manager", "org.jboss.logmanager.LogManager");
                System.setProperty("org.jboss.logmanager.configurator", "org.wildfly.swarm.container.runtime.wildfly.LoggingConfigurator");
                LogManager.getLogManager();
                Class logManagerClass = loggingModule.getClassLoader().loadClass("org.wildfly.swarm.container.runtime.logging.JBossLoggingManager");
                BootstrapLogger.setBackingLoggerManager((BackingLoggerManager)((BackingLoggerManager)logManagerClass.newInstance()));
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalCl);
            }
        }
        catch (ModuleLoadException e) {
            System.err.println("[WARN] logging not available, logging will not be configured");
        }
        this.installModuleMBeanServer();
        this.createShrinkWrapDomain();
        this.configView = ConfigViewFactory.defaultFactory(properties, environment);
        this.commandLine = CommandLine.parse(args);
        this.commandLine.apply(this);
        this.initializeConfigView(properties);
        this.isConstructing = false;
    }

    public CommandLine getCommandLine() {
        return this.commandLine;
    }

    public void setArgs(String ... args) {
        this.args = args;
    }

    public Swarm withXmlConfig(URL url) {
        this.xmlConfig = Optional.of(url);
        return this;
    }

    public Swarm withConfig(URL url) throws IOException {
        if (!this.isConstructing) {
            String uuid = UUID.randomUUID().toString();
            this.configView.load(uuid, url);
            this.configView.withProfile(uuid);
        }
        this.configs.add(url);
        return this;
    }

    public Swarm withProfile(String name) {
        if (!this.isConstructing) {
            this.configView.load(name);
            this.configView.withProfile(name);
        }
        this.profiles.add(name);
        return this;
    }

    public Swarm withProperty(String name, String value) {
        this.configView.withProperty(name, value);
        return this;
    }

    public Swarm fraction(Fraction fraction) {
        this.explicitlyInstalledFractions.add(fraction);
        return this;
    }

    public Swarm component(Class<?> cls) {
        this.userComponentClasses.add(cls);
        return this;
    }

    public Swarm outboundSocketBinding(String socketBindingGroup, OutboundSocketBinding binding) {
        this.outboundSocketBindings.add(new OutboundSocketBindingRequest(socketBindingGroup, binding));
        return this;
    }

    public Swarm socketBinding(String socketBindingGroup, SocketBinding binding) {
        this.socketBindings.add(new SocketBindingRequest(socketBindingGroup, binding));
        return this;
    }

    public Swarm start() throws Exception {
        INSTANCE = this;
        try (AutoCloseable handle = Performance.time((String)"Swarm.start()");){
            Module module = Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)CONTAINER_MODULE_NAME));
            Class bootstrapClass = module.getClassLoader().loadClass("org.wildfly.swarm.container.runtime.ServerBootstrapImpl");
            ServerBootstrap bootstrap = (ServerBootstrap)bootstrapClass.newInstance();
            bootstrap.withArguments(this.args).withBootstrapDebug(this.debugBootstrap).withExplicitlyInstalledFractions(this.explicitlyInstalledFractions).withSocketBindings(this.socketBindings).withOutboundSocketBindings(this.outboundSocketBindings).withUserComponents(this.userComponentClasses).withXmlConfig(this.xmlConfig).withConfigView(this.configView.get(true));
            this.server = bootstrap.bootstrap();
            Swarm swarm = this;
            return swarm;
        }
    }

    public Swarm start(Archive<?> deployment) throws Exception {
        return this.start().deploy(deployment);
    }

    public Swarm stop() throws Exception {
        if (this.server == null) {
            throw SwarmMessages.MESSAGES.containerNotStarted("stop()");
        }
        this.server.stop();
        this.server = null;
        Module module = Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)CONTAINER_MODULE_NAME));
        Class shutdownClass = module.getClassLoader().loadClass("org.wildfly.swarm.container.runtime.WeldShutdownImpl");
        WeldShutdown shutdown = (WeldShutdown)shutdownClass.newInstance();
        shutdown.shutdown();
        return this;
    }

    public Swarm deploy() throws IllegalStateException, DeploymentException {
        if (this.server == null) {
            throw SwarmMessages.MESSAGES.containerNotStarted("deploy()");
        }
        if (ApplicationEnvironment.get().isHollow()) {
            this.server.deployer().deploy(this.getCommandLine().extraArguments().stream().map(e -> Paths.get(e, new String[0])).collect(Collectors.toList()));
        } else {
            this.server.deployer().deploy();
        }
        return this;
    }

    public Swarm deploy(Archive<?> deployment) throws Exception {
        if (this.server == null) {
            throw SwarmMessages.MESSAGES.containerNotStarted("deploy(Archive<?>)");
        }
        this.server.deployer().deploy(deployment);
        return this;
    }

    public Archive<?> createDefaultDeployment() throws Exception {
        if (this.server == null) {
            throw SwarmMessages.MESSAGES.containerNotStarted("createDefaultDeployment()");
        }
        return this.server.deployer().createDefaultDeployment();
    }

    private void createShrinkWrapDomain() {
        ClassLoader originalCl = Thread.currentThread().getContextClassLoader();
        try {
            if (Swarm.isFatJar()) {
                Module appModule = Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)APPLICATION_MODULE_NAME));
                Thread.currentThread().setContextClassLoader((ClassLoader)appModule.getClassLoader());
            }
            Domain domain = ShrinkWrap.getDefaultDomain();
            domain.getConfiguration().getExtensionLoader().addOverride(ZipExporter.class, ZipExporterImpl.class);
            domain.getConfiguration().getExtensionLoader().addOverride(ZipImporter.class, ZipImporterImpl.class);
            domain.getConfiguration().getExtensionLoader().addOverride(ExplodedExporter.class, ExplodedExporterImpl.class);
            domain.getConfiguration().getExtensionLoader().addOverride(ExplodedImporter.class, ExplodedImporterImpl.class);
            domain.getConfiguration().getExtensionLoader().addOverride(JavaArchive.class, JavaArchiveImpl.class);
            domain.getConfiguration().getExtensionLoader().addOverride(WebArchive.class, WebArchiveImpl.class);
        }
        catch (Exception e) {
            SwarmMessages.MESSAGES.shrinkwrapDomainSetupFailed(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCl);
        }
    }

    private static boolean isFatJar() throws IOException {
        block34: {
            URL location = Swarm.class.getProtectionDomain().getCodeSource().getLocation();
            Path root = null;
            if (location.getProtocol().equals("file")) {
                try {
                    root = Paths.get(location.toURI());
                }
                catch (URISyntaxException e) {
                    throw new IOException(e);
                }
            } else if (location.toExternalForm().startsWith("jar:file:")) {
                return true;
            }
            if (Files.isRegularFile(root, new LinkOption[0])) {
                try (JarFile jar = new JarFile(root.toFile());){
                    ZipEntry propsEntry = jar.getEntry("META-INF/wildfly-swarm.properties");
                    if (propsEntry == null) break block34;
                    try (InputStream in = jar.getInputStream(propsEntry);){
                        Properties props = new Properties();
                        props.load(in);
                        if (props.containsKey("swarm.app.artifact")) {
                            System.setProperty("swarm.app.artifact", props.getProperty("swarm.app.artifact"));
                        }
                        Set<String> names = props.stringPropertyNames();
                        for (String name : names) {
                            String value = props.getProperty(name);
                            if (System.getProperty(name) != null) continue;
                            System.setProperty(name, value);
                        }
                    }
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }

    private void initializeConfigView(Properties props) throws IOException, ModuleLoadException {
        try (AutoCloseable handle = Performance.time((String)"Loading YAML");){
            String projectStageProp;
            if (System.getProperty("swarm.project.stage.file") != null) {
                String file = System.getProperty("swarm.project.stage.file");
                boolean loaded = false;
                try {
                    Path path = Paths.get(file, new String[0]);
                    if (Files.exists(path, new LinkOption[0])) {
                        this.configView.load("stages", path.toUri().toURL());
                        loaded = true;
                    }
                }
                catch (InvalidPathException path) {
                    // empty catch block
                }
                if (!loaded) {
                    try {
                        URL url = new URL(file);
                        this.configView.load("stages", url);
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
            }
            if ((projectStageProp = System.getProperty("swarm.project.stage")) == null && props != null) {
                projectStageProp = props.getProperty("swarm.project.stage");
            }
            if (projectStageProp == null && (projectStageProp = (String)this.configView.get().resolve("swarm.project.stage").withDefault((Object)"NOT_FOUND").getValue()) != null && projectStageProp.equals("NOT_FOUND")) {
                projectStageProp = null;
            }
            if (projectStageProp != null) {
                String[] activated = projectStageProp.split(",");
                for (String each : activated) {
                    this.configView.load(each);
                    this.configView.withProfile(each);
                }
            }
            int counter = 0;
            for (URL config : this.configs) {
                String syntheticName = "cli-" + ++counter;
                this.configView.load(syntheticName, config);
                this.configView.withProfile(syntheticName);
            }
            this.configView.load("stages");
            for (String profile : this.profiles) {
                this.configView.load(profile);
                this.configView.withProfile(profile);
            }
            this.configView.load("defaults");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String ... args) throws Exception {
        if (System.getProperty(BOOT_MODULE_PROPERTY) == null) {
            System.setProperty(BOOT_MODULE_PROPERTY, "org.wildfly.swarm.bootstrap.modules.BootModuleLoader");
        }
        swarm = new Swarm(args);
        try {
            swarm.start();
            if (System.getProperty("swarm.inhibit.default-deployment") == null) {
                swarm.deploy();
            }
        }
        catch (VirtualMachineError vme) {
            vme.printStackTrace();
            System.exit(1);
        }
        catch (Throwable t) {
            Swarm.tryToStopAfterStartupError(t, swarm);
            throw t;
        }
        Swarm.displayUsage();
    }

    public static void stopMain() throws Exception {
        try {
            if (swarm != null) {
                swarm.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void tryToStopAfterStartupError(Throwable errorCause, Swarm swarm) {
        if (swarm.server != null) {
            try {
                swarm.stop();
            }
            catch (Throwable t) {
                errorCause.printStackTrace();
                t.printStackTrace();
                System.exit(1);
            }
        }
    }

    private static void displayUsage() throws Exception {
        Swarm.swarm.server.displayUsage();
    }

    private static ArtifactLookup artifactLookup() {
        return ArtifactLookup.get();
    }

    public static JavaArchive artifact(String gav) throws Exception {
        return Swarm.artifactLookup().artifact(gav);
    }

    public static JavaArchive artifact(String gav, String asName) throws Exception {
        return Swarm.artifactLookup().artifact(gav, asName);
    }

    public static List<JavaArchive> allArtifacts() throws Exception {
        return Swarm.artifactLookup().allArtifacts();
    }

    private void installModuleMBeanServer() {
        try {
            Method method = ModuleLoader.class.getDeclaredMethod("installMBeanServer", new Class[0]);
            method.setAccessible(true);
            method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            SwarmMessages.MESSAGES.moduleMBeanServerNotInstalled(e);
        }
    }

    public ConfigView configView() {
        return this.configView.get();
    }

    @Deprecated
    public StageConfig stageConfig() {
        return this.configView.get();
    }
}

