/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.config;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.stream.Stream;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.wildfly.swarm.container.config.ConfigLocator;

public class ClassLoaderConfigLocator
extends ConfigLocator {
    private final ClassLoader classLoader;

    public static ClassLoaderConfigLocator system() {
        return new ClassLoaderConfigLocator(ClassLoader.getSystemClassLoader());
    }

    public static ClassLoaderConfigLocator forApplication() throws ModuleLoadException {
        Module appModule = Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)"swarm.application"));
        return new ClassLoaderConfigLocator((ClassLoader)appModule.getClassLoader());
    }

    private ClassLoaderConfigLocator(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public Stream<URL> locate(String profileName) throws IOException {
        URL each;
        ArrayList<URL> located = new ArrayList<URL>();
        Enumeration<URL> resources = this.classLoader.getResources("project-" + profileName + ".yml");
        while (resources.hasMoreElements()) {
            each = resources.nextElement();
            located.add(each);
        }
        resources = this.classLoader.getResources("project-" + profileName + ".yaml");
        while (resources.hasMoreElements()) {
            each = resources.nextElement();
            located.add(each);
        }
        resources = this.classLoader.getResources("project-" + profileName + ".properties");
        while (resources.hasMoreElements()) {
            each = resources.nextElement();
            located.add(each);
        }
        return located.stream();
    }
}

