/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.wildfly.swarm.container.config.ConfigNode;
import org.wildfly.swarm.container.config.EnvironmentConfigNodeFactory;
import org.wildfly.swarm.container.config.PropertiesConfigNodeFactory;
import org.wildfly.swarm.container.config.PropertiesManipulator;
import org.wildfly.swarm.spi.api.config.ConfigKey;
import org.wildfly.swarm.spi.api.config.SimpleKey;

class ConfigResolutionStrategy {
    private PropertiesManipulator properties;
    private List<ConfigNode> nodes = new ArrayList<ConfigNode>();
    private ConfigNode defaults;
    private ConfigNode propertiesNode;

    ConfigResolutionStrategy() {
        this(PropertiesManipulator.system());
    }

    ConfigResolutionStrategy(Properties properties) {
        this(properties == null ? PropertiesManipulator.system() : PropertiesManipulator.forProperties(properties));
    }

    private ConfigResolutionStrategy(PropertiesManipulator properties) {
        this.propertiesNode = PropertiesConfigNodeFactory.load(properties.getProperties());
        this.nodes.add(this.propertiesNode);
        this.properties = properties;
    }

    void withProperties(Properties properties) {
        this.propertiesNode = PropertiesConfigNodeFactory.load(properties);
        this.nodes.add(this.propertiesNode);
        this.properties = PropertiesManipulator.forProperties(properties);
    }

    void withEnvironment(Map<String, String> environment) {
        this.nodes.add(EnvironmentConfigNodeFactory.load(environment));
    }

    void add(ConfigNode node) {
        this.nodes.add(node);
    }

    void defaults(ConfigNode defaults) {
        this.defaults = defaults;
    }

    void withProperty(String name, String value) {
        this.propertiesNode.recursiveChild(name, (Object)value);
    }

    void activate() {
        this.nodes().flatMap(e -> e.allKeysRecursively()).distinct().forEach(key -> this.activate((ConfigKey)key));
    }

    Stream<ConfigNode> nodes() {
        if (this.defaults == null) {
            return this.nodes.stream();
        }
        return Stream.concat(this.nodes.stream(), Stream.of(this.defaults));
    }

    private void activate(ConfigKey key) {
        this.optionalValueOf(key).ifPresent(v -> this.properties.setProperty(key.name(), v.toString()));
    }

    private void deactivate(ConfigKey key) {
        this.optionalValueOf(key).ifPresent(v -> this.properties.clearProperty(key.name()));
    }

    public Object valueOf(ConfigKey key) {
        return this.optionalValueOf(key).orElse(null);
    }

    Optional<Object> optionalValueOf(ConfigKey key) {
        return this.nodes().map(e -> e.valueOf(key)).filter(Objects::nonNull).findFirst();
    }

    Stream<ConfigKey> allKeysRecursively() {
        return this.nodes().flatMap(e -> e.allKeysRecursively());
    }

    List<SimpleKey> simpleSubkeysOf(ConfigKey prefix) {
        return this.nodes().map(e -> e.descendant(prefix)).filter(Objects::nonNull).flatMap(e -> e.childrenKeys().stream()).distinct().collect(Collectors.toList());
    }

    boolean hasKeyOrSubkeys(ConfigKey prefix) {
        return this.nodes().map(e -> e.descendant(prefix)).anyMatch(Objects::nonNull);
    }

    Properties asProperties() {
        return this.properties.getProperties();
    }
}

