/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.datasources.runtime;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarFile;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.ResourceLoaderSpec;
import org.jboss.modules.ResourceLoaders;
import org.wildfly.swarm.bootstrap.modules.DynamicModuleFinder;
import org.wildfly.swarm.config.datasources.DataSource;
import org.wildfly.swarm.config.datasources.DataSourceConsumer;
import org.wildfly.swarm.config.datasources.JDBCDriver;
import org.wildfly.swarm.datasources.DatasourcesFraction;
import org.wildfly.swarm.datasources.runtime.DatasourcesMessages;

public abstract class DriverInfo {
    private final String name;
    private final ModuleIdentifier moduleIdentifier;
    private final String detectableClassName;
    private final String[] optionalClassNames;
    private boolean installed;
    private static final String FILE_PREFIX = "file:";
    private static final String JAR_FILE_PREFIX = "jar:file:";

    protected DriverInfo(String name, ModuleIdentifier moduleIdentifier, String detectableClassName, String ... optionalClassNames) {
        this.name = name;
        this.moduleIdentifier = moduleIdentifier;
        this.detectableClassName = detectableClassName;
        this.optionalClassNames = optionalClassNames;
    }

    public String name() {
        return this.name;
    }

    protected void configureDriver(JDBCDriver driver) {
    }

    protected abstract void configureDefaultDS(DataSource var1);

    public boolean detect(DatasourcesFraction fraction) {
        if (fraction.subresources().jdbcDriver(this.name) != null) {
            return true;
        }
        DatasourcesMessages.MESSAGES.attemptToAutoDetectJdbcDriver(this.name);
        File primaryJar = this.attemptDetection();
        if (primaryJar != null) {
            Set<File> optionalJars = this.findOptionalJars();
            optionalJars.add(primaryJar);
            fraction.jdbcDriver(this.name, driver -> {
                driver.driverModuleName(this.moduleIdentifier.getName());
                driver.moduleSlot(this.moduleIdentifier.getSlot());
                this.configureDriver(driver);
            });
            DynamicModuleFinder.register((ModuleIdentifier)this.moduleIdentifier, (id, loader) -> {
                ModuleSpec.Builder builder = ModuleSpec.build((ModuleIdentifier)id);
                for (File eachJar : optionalJars) {
                    try {
                        JarFile jar = new JarFile(eachJar);
                        builder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec((ResourceLoader)ResourceLoaders.createIterableJarResourceLoader((String)jar.getName(), (JarFile)jar)));
                    }
                    catch (IOException e) {
                        DatasourcesMessages.MESSAGES.errorLoadingAutodetectedJdbcDriver(this.name, e);
                        return null;
                    }
                }
                builder.addDependency(DependencySpec.createModuleDependencySpec((ModuleIdentifier)ModuleIdentifier.create((String)"javax.api")));
                builder.addDependency(DependencySpec.createModuleDependencySpec((ModuleIdentifier)ModuleIdentifier.create((String)"javax.transactions.api"), (boolean)false, (boolean)true));
                builder.addDependency(DependencySpec.createLocalDependencySpec());
                return builder.create();
            });
            this.installed = true;
        }
        return this.installed;
    }

    private File attemptDetection() {
        return this.findLocationOfClass(this.detectableClassName);
    }

    private Set<File> findOptionalJars() {
        HashSet<File> optionalJars = new HashSet<File>();
        if (this.optionalClassNames != null) {
            for (String each : this.optionalClassNames) {
                File file = this.findLocationOfClass(each);
                if (file == null) continue;
                optionalJars.add(file);
            }
        }
        return optionalJars;
    }

    private File findLocationOfClass(String className) {
        try {
            ModuleClassLoader cl = Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)"swarm.application")).getClassLoader();
            File candidate = this.findLocationOfClass((ClassLoader)cl, className);
            if (candidate == null) {
                candidate = this.findLocationOfClass(ClassLoader.getSystemClassLoader(), className);
            }
            return candidate;
        }
        catch (ModuleLoadException cl) {
        }
        catch (IOException e) {
            DatasourcesMessages.MESSAGES.errorLoadingAutodetectedJdbcDriver(this.name, e);
        }
        return null;
    }

    private File findLocationOfClass(ClassLoader classLoader, String className) throws IOException {
        try {
            Class<?> driverClass = classLoader.loadClass(className);
            URL location = driverClass.getProtectionDomain().getCodeSource().getLocation();
            String locationStr = location.toExternalForm();
            if (locationStr.startsWith(JAR_FILE_PREFIX)) {
                locationStr = locationStr.substring(JAR_FILE_PREFIX.length());
            } else if (locationStr.startsWith(FILE_PREFIX)) {
                locationStr = locationStr.substring(FILE_PREFIX.length());
            }
            int bangLoc = locationStr.indexOf(33);
            if (bangLoc >= 0) {
                locationStr = locationStr.substring(0, bangLoc);
            }
            locationStr = this.getPlatformPath(locationStr);
            File locationFile = Paths.get(locationStr, new String[0]).toFile();
            return locationFile;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    protected String getPlatformPath(String path) {
        if (!this.isWindows()) {
            return path;
        }
        URI uri = URI.create("file://" + path);
        return Paths.get(uri).toString();
    }

    protected boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("win");
    }

    public boolean isInstalled() {
        return this.installed;
    }

    public String toString() {
        return "[DriverInfo: detectable=" + this.detectableClassName + "]";
    }

    public void installDatasource(DatasourcesFraction fraction, String dsName, DataSourceConsumer config) {
        fraction.dataSource(dsName, ds -> {
            ds.driverName(this.name);
            this.configureDefaultDS(ds);
            config.accept(ds);
        });
    }
}

