/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.ejb.runtime;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.wildfly.swarm.config.security.Flag;
import org.wildfly.swarm.config.security.SecurityDomain;
import org.wildfly.swarm.security.SecurityFraction;
import org.wildfly.swarm.spi.api.Customizer;
import org.wildfly.swarm.spi.runtime.annotations.Post;

@Post
@Singleton
public class EJBSecurityCustomizer
implements Customizer {
    @Inject
    private SecurityFraction security;

    public void customize() {
        if (this.security.subresources().securityDomains().stream().anyMatch(e -> e.getKey().equals("jboss-ejb-policy"))) {
            return;
        }
        this.security.securityDomain("jboss-ejb-policy", policy -> {
            policy.cacheType(SecurityDomain.CacheType.DEFAULT);
            policy.classicAuthorization(auth -> auth.policyModule("Delegating", module -> {
                module.code("Delegating");
                module.flag(Flag.REQUIRED);
            }));
        });
    }
}

