/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.flyway.deployment;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.Vetoed;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;

@Vetoed
@WebListener
public class FlywayMigrationServletContextListener
implements ServletContextListener {
    public static final String FLYWAY_JNDI_DATASOURCE = "flyway.jndi.datasource";
    public static final String FLYWAY_JDBC_PASSWORD = "flyway.jdbc.password";
    public static final String FLYWAY_JDBC_USER = "flyway.jdbc.user";
    public static final String FLYWAY_JDBC_URL = "flyway.jdbc.url";
    private static final Logger logger = Logger.getLogger(FlywayMigrationServletContextListener.class.getName());

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext sc = sce.getServletContext();
        Flyway flyway = new Flyway();
        String dataSourceJndi = sc.getInitParameter(FLYWAY_JNDI_DATASOURCE);
        if (dataSourceJndi != null) {
            try {
                DataSource dataSource = (DataSource)new InitialContext().lookup(dataSourceJndi);
                flyway.setDataSource(dataSource);
            }
            catch (NamingException ex) {
                logger.log(Level.SEVERE, "Error while looking up DataSource", ex);
                return;
            }
        } else {
            String url = sc.getInitParameter(FLYWAY_JDBC_URL);
            String user = sc.getInitParameter(FLYWAY_JDBC_USER);
            String password = sc.getInitParameter(FLYWAY_JDBC_PASSWORD);
            flyway.setDataSource(url, user, password, new String[0]);
        }
        flyway.migrate();
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

