/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.fractionlist;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.wildfly.swarm.fractionlist.FractionDescriptor;

public class FractionList {
    private Map<String, FractionDescriptor> descriptors = new HashMap<String, FractionDescriptor>();

    public FractionList() {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("fraction-list.txt")));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                String[] deps;
                if ((line = line.trim()).isEmpty()) continue;
                String[] sides = line.split("=");
                String lhs = sides[0].trim();
                FractionDescriptor desc = this.descriptors.get(lhs);
                if (desc == null) {
                    String[] gavParts = lhs.split(":");
                    desc = new FractionDescriptor(gavParts[0], gavParts[1]);
                    this.descriptors.put(lhs, desc);
                }
                if (sides.length <= 1) continue;
                String rhs = sides[1].trim();
                for (String dep : deps = rhs.split(",")) {
                    if ((dep = dep.trim()).isEmpty()) continue;
                    FractionDescriptor depDesc = this.descriptors.get(dep);
                    if (depDesc == null) {
                        String[] gavParts = dep.split(":");
                        depDesc = new FractionDescriptor(gavParts[0], gavParts[1]);
                    }
                    desc.addDependency(depDesc);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Collection<FractionDescriptor> getFractionDescriptors() {
        return Collections.unmodifiableCollection(this.descriptors.values());
    }

    public FractionDescriptor getFractionDescriptor(String groupId, String artifactId) {
        return this.descriptors.get(groupId + ":" + artifactId);
    }
}

