/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.fractionlist;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class FractionDescriptor {
    private final String groupId;
    private final String artifactId;
    private Set<FractionDescriptor> dependencies = new HashSet<FractionDescriptor>();

    FractionDescriptor(String groupId, String artifactId) {
        this.groupId = groupId;
        this.artifactId = artifactId;
    }

    void addDependency(FractionDescriptor dep) {
        this.dependencies.add(dep);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public Set<FractionDescriptor> getDependencies() {
        return Collections.unmodifiableSet(this.dependencies);
    }

    public String toString() {
        return this.groupId + ":" + this.artifactId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
        result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FractionDescriptor other = (FractionDescriptor)obj;
        if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
            return false;
        }
        return !(this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId));
    }
}

