/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.fractionlist;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.wildfly.swarm.tools.FractionDescriptor;
import org.wildfly.swarm.tools.PropertiesUtil;

public class FractionList
implements org.wildfly.swarm.tools.FractionList {
    private final Map<String, FractionDescriptor> descriptors = new TreeMap<String, FractionDescriptor>();
    private static final AtomicReference<FractionList> INSTANCE = new AtomicReference();

    public static FractionList get() {
        return INSTANCE.updateAndGet(old -> old != null ? old : new FractionList());
    }

    private FractionList() {
        Throwable throwable;
        Reader reader;
        try {
            reader = new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("fraction-list.json"));
            throwable = null;
            try {
                Json.parse((Reader)reader).asArray().forEach(entry -> {
                    JsonObject fraction = entry.asObject();
                    String groupId = fraction.getString("groupId", null);
                    String artifactId = fraction.getString("artifactId", null);
                    String version = fraction.getString("version", null);
                    String name = fraction.getString("name", null);
                    String description = fraction.getString("description", null);
                    String tags = fraction.getString("tags", null);
                    boolean internal = fraction.getBoolean("internal", false);
                    FractionDescriptor fd = new FractionDescriptor(groupId, artifactId, version, name, description, tags, internal);
                    this.descriptors.put(groupId + ":" + artifactId, fd);
                });
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader != null) {
                    if (throwable != null) {
                        try {
                            ((InputStreamReader)reader).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((InputStreamReader)reader).close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            reader = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("fraction-list.txt")));
            throwable = null;
            try {
                String line = null;
                while ((line = ((BufferedReader)reader).readLine()) != null) {
                    String[] deps;
                    if ((line = line.trim()).isEmpty()) continue;
                    String[] sides = line.split("=");
                    String lhs = sides[0].trim();
                    FractionDescriptor desc = this.descriptors.get(lhs);
                    if (desc == null) {
                        String[] gavParts = lhs.split(":");
                        desc = new FractionDescriptor(gavParts[0], gavParts[1], gavParts[2]);
                        this.descriptors.put(gavParts[0] + ":" + gavParts[1], desc);
                    }
                    if (sides.length <= 1) continue;
                    String rhs = sides[1].trim();
                    for (String dep : deps = rhs.split(",")) {
                        if ((dep = dep.trim()).isEmpty()) continue;
                        FractionDescriptor depDesc = this.descriptors.get(dep);
                        if (depDesc == null) {
                            String[] gavParts = dep.split(":");
                            depDesc = new FractionDescriptor(gavParts[0], gavParts[1], gavParts[2]);
                            this.descriptors.put(gavParts[0] + ":" + gavParts[1], depDesc);
                        }
                        desc.addDependency(depDesc);
                    }
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (reader != null) {
                    if (throwable != null) {
                        try {
                            ((BufferedReader)reader).close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        ((BufferedReader)reader).close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Collection<FractionDescriptor> getFractionDescriptors() {
        return Collections.unmodifiableCollection(this.descriptors.values());
    }

    public FractionDescriptor getFractionDescriptor(String groupId, String artifactId) {
        return this.descriptors.get(groupId + ":" + artifactId);
    }

    public Map<String, FractionDescriptor> getPackageSpecs() {
        Map<String, String> packageSpecs = FractionList.loadPackageSpecs();
        return this.descriptors.values().stream().filter(fd -> packageSpecs.containsKey(fd.artifactId())).collect(Collectors.toMap(fd -> (String)packageSpecs.get(fd.artifactId()), fd -> fd));
    }

    private static Map<String, String> loadPackageSpecs() {
        try {
            InputStream in = FractionList.class.getClassLoader().getResourceAsStream("org/wildfly/swarm/fractionlist/fraction-packages.properties");
            return new HashMap<Object, Object>(PropertiesUtil.loadProperties((InputStream)in));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load fraction-packages.properties", e);
        }
    }
}

