/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.cdi.detect;

import java.io.File;
import org.wildfly.swarm.spi.meta.FileDetector;
import org.wildfly.swarm.spi.meta.PathSource;

public class BeansXmlDetector
extends FileDetector {
    private static final String XML = "xml";
    private static final String BEANS_XML_WEB_INF_1 = "WEB-INF" + File.separator + "beans.xml";
    private static final String BEANS_XML_WEB_INF_2 = "WEB-INF" + File.separator + "classes" + File.separator + "META-INF" + File.separator + "beans.xml";
    private static final String BEANS_XML_META_INF = "META-INF" + File.separator + "beans.xml";
    private static final String CDI = "cdi";
    private boolean detected = false;
    private boolean detectionComplete = false;

    public String extensionToDetect() {
        return XML;
    }

    public boolean detectionComplete() {
        return this.detectionComplete;
    }

    public boolean wasDetected() {
        return this.detected;
    }

    public void detect(PathSource fileSource) {
        String relativePath = fileSource.getRelativePath();
        if (!this.detectionComplete() && (relativePath.equals(BEANS_XML_WEB_INF_1) || relativePath.equals(BEANS_XML_WEB_INF_2) || relativePath.equals(BEANS_XML_META_INF))) {
            this.detected = true;
            this.detectionComplete = true;
        }
    }

    public String artifactId() {
        return CDI;
    }
}

