/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.arquillian.adapter.gradle;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.wildfly.swarm.arquillian.adapter.DependencyDeclarationFactory;
import org.wildfly.swarm.arquillian.adapter.gradle.GradleDependencyAdapter;
import org.wildfly.swarm.arquillian.resolver.ShrinkwrapArtifactResolvingHelper;
import org.wildfly.swarm.bootstrap.util.MavenArtifactDescriptor;
import org.wildfly.swarm.internal.FileSystemLayout;
import org.wildfly.swarm.internal.GradleFileSystemLayout;
import org.wildfly.swarm.tools.ArtifactSpec;
import org.wildfly.swarm.tools.DeclaredDependencies;

public class GradleDependencyDeclarationFactory
implements DependencyDeclarationFactory {
    public DeclaredDependencies create(FileSystemLayout fsLayout, ShrinkwrapArtifactResolvingHelper resolvingHelper) {
        GradleDependencyAdapter gradleAdapter = new GradleDependencyAdapter(fsLayout.getRootPath());
        DeclaredDependencies declaredDependencies = gradleAdapter.parseDependencies(GradleDependencyAdapter.Configuration.TEST_RUNTIME);
        GradleDependencyDeclarationFactory.resolveDependencies(declaredDependencies.getRuntimeExplicitAndTransientDependencies(), resolvingHelper);
        return declaredDependencies;
    }

    public boolean acceptsFsLayout(FileSystemLayout fsLayout) {
        return fsLayout instanceof GradleFileSystemLayout;
    }

    private static void resolveDependencies(Collection<ArtifactSpec> collection, ShrinkwrapArtifactResolvingHelper helper) {
        Map<String, File> resolvedArtifactMap = helper.resolveAll(collection, false, true).stream().collect(Collectors.toMap(MavenArtifactDescriptor::mavenGav, s -> s.file));
        collection.parallelStream().forEach(s -> resolvedArtifactMap.computeIfPresent(s.mavenGav(), (k, file) -> {
            s.file = file;
            return s.file;
        }));
    }
}

