/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.database.h2.runtime;

import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.wildfly.swarm.datasources.DatasourcesFraction;
import org.wildfly.swarm.spi.api.Customizer;
import org.wildfly.swarm.spi.runtime.annotations.Pre;

@Singleton
@Pre
public class H2DatasourceCustomizer
implements Customizer {
    @Inject
    @Any
    Instance<DatasourcesFraction> datasourcesFractionInstance;

    public void customize() {
        if (!this.datasourcesFractionInstance.isUnsatisfied()) {
            String dsName = System.getProperty("swarm.ds.name", "ExampleDS");
            String driverName = System.getProperty("swarm.jdbc.driver", "h2");
            ((DatasourcesFraction)this.datasourcesFractionInstance.get()).jdbcDriver(driverName, d -> {
                d.driverClassName("org.h2.Driver");
                d.xaDatasourceClass("org.h2.jdbcx.JdbcDataSource");
                d.driverModuleName("com.h2database.h2");
            }).dataSource(dsName, ds -> {
                ds.driverName(driverName);
                ds.connectionUrl(System.getProperty("swarm.ds.connection.url", "jdbc:h2:mem:test;DB_CLOSE_DELAY=-1;DB_CLOSE_ON_EXIT=FALSE"));
                ds.userName(System.getProperty("swarm.ds.username", "sa"));
                ds.password(System.getProperty("swarm.ds.password", "sa"));
            });
        }
    }
}

