/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.hawkular.server.runtime;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ValueExpression;
import org.wildfly.swarm.SwarmProperties;
import org.wildfly.swarm.container.runtime.AbstractServerConfiguration;
import org.wildfly.swarm.hawkular.server.HawkularServerFraction;

public class HawkularServerConfiguration
extends AbstractServerConfiguration<HawkularServerFraction> {
    public HawkularServerConfiguration() {
        super(HawkularServerFraction.class);
        this.deployment("org.hawkular.commons:hawkular-commons-embedded-cassandra-ear:ear:*").as("hawkular-commons-embedded-cassandra-ear.ear");
        this.deployment("org.keycloak.secretstore:secret-store:war:*").as("hawkular-accounts-secret-store.war");
        this.deployment("org.hawkular.accounts:hawkular-accounts-events-backend:war:*").as("hawkular-accounts-events-backend.war");
        this.deployment("org.hawkular.accounts:hawkular-accounts:war:*").as("hawkular-accounts.war");
        this.deployment("org.hawkular:hawkular-console:war:*").as("hawkular-console.war");
    }

    public List<ModelNode> getList(HawkularServerFraction fraction) {
        ArrayList<ModelNode> list = new ArrayList<ModelNode>();
        this.getNestList(fraction, list);
        return list;
    }

    protected void getNestList(HawkularServerFraction fraction, List<ModelNode> list) {
        ModelNode node = new ModelNode();
        node.get("address").set("extension", "org.hawkular.nest");
        node.get("operation").set("add");
        list.add(node);
        PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"hawkular-nest")});
        node = new ModelNode();
        node.get("address").set(address.toModelNode());
        node.get("operation").set("add");
        node.get("nest-name").set("autogenerate");
        node.get("enabled").set(true);
        list.add(node);
        list.add(this.property("hawkular.metrics.waitForService", SwarmProperties.propertyVar((String)"hawkular.metrics.waitForService", (String)"True")));
        list.add(this.property("hawkular.backend", SwarmProperties.propertyVar((String)"hawkular.backend", (String)"embedded_cassandra")));
        list.add(this.property("keycloak.server.url", SwarmProperties.propertyVar((String)"keycloak.server.url", (String)"http://localhost:8080/auth")));
    }

    protected ModelNode property(String name, String value) {
        ModelNode node = new ModelNode();
        node.get("address").set("system-property", name);
        node.get("operation").set("add");
        node.get("value").set(new ValueExpression(value));
        return node;
    }
}

