/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.health;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.wildfly.swarm.microprofile.health.BuiltResponse;

public class BuilderImpl
extends HealthCheckResponseBuilder {
    private String name;
    private Optional<Map<String, Object>> attributes = Optional.empty();
    private HealthCheckResponse.State state;

    public HealthCheckResponseBuilder up() {
        return this.state(true);
    }

    public HealthCheckResponseBuilder down() {
        return this.state(false);
    }

    public HealthCheckResponse build() {
        this.assertNamed();
        BuiltResponse response = new BuiltResponse(this.name).setState(this.state);
        if (this.attributes.isPresent()) {
            response.withAttributes(this.attributes.get());
        }
        return response;
    }

    public HealthCheckResponseBuilder state(boolean up) {
        this.state = up ? HealthCheckResponse.State.UP : HealthCheckResponse.State.DOWN;
        return this;
    }

    public HealthCheckResponseBuilder name(String name) {
        this.name = name;
        return this;
    }

    private void assertNamed() {
        if (this.name == null) {
            throw new IllegalStateException("ResponseBuilder need to be named");
        }
    }

    public HealthCheckResponseBuilder withData(String key, String value) {
        Map<String, Object> payload = this.getPayloadWrapper();
        payload.put(key, value);
        return this;
    }

    public HealthCheckResponseBuilder withData(String key, long value) {
        Map<String, Object> payload = this.getPayloadWrapper();
        payload.put(key, value);
        return this;
    }

    public HealthCheckResponseBuilder withData(String key, boolean value) {
        Map<String, Object> payload = this.getPayloadWrapper();
        payload.put(key, value);
        return this;
    }

    private Map<String, Object> getPayloadWrapper() {
        if (!this.attributes.isPresent()) {
            this.attributes = Optional.of(new HashMap());
        }
        return this.attributes.get();
    }
}

