/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.netflix.hystrix;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.spi.api.Defaultable;
import org.wildfly.swarm.spi.api.Fraction;
import org.wildfly.swarm.spi.api.annotations.Configurable;
import org.wildfly.swarm.spi.api.annotations.DeploymentModule;
import org.wildfly.swarm.spi.api.annotations.DeploymentModules;

@DeploymentModules(value={@DeploymentModule(name="com.netflix.hystrix"), @DeploymentModule(name="io.reactivex.rxjava")})
public class HystrixFraction
implements Fraction<HystrixFraction> {
    @AttributeDocumentation(value="Context path for the stream")
    @Configurable(value="swarm.hystrix.stream.path")
    private Defaultable<String> streamPath = Defaultable.string((String)"/hystrix.stream");
    @AttributeDocumentation(value="Isolation strategy (THREAD or SEMAPHORE)")
    @Configurable(value="swarm.hystrix.command.default.execution.isolation.strategy")
    private Defaultable<String> isolationStrategy = Defaultable.string((String)"THREAD");
    @AttributeDocumentation(value="The time in milliseconds after which the caller will observe a timeout and walk away from the command execution")
    @Configurable(value="swarm.hystrix.command.default.execution.isolation.thread.timeoutInMilliseconds")
    private Defaultable<Long> threadTimeoutInMilliseconds = Defaultable.longInteger((long)1000L);
    @AttributeDocumentation(value="Indicates whether the HystrixCommand.run() execution should have a timeout")
    @Configurable(value="swarm.hystrix.command.default.execution.timeout.enabled")
    private Defaultable<Boolean> threadTimeoutEnabled = Defaultable.bool((boolean)true);
    @AttributeDocumentation(value="Indicates whether the HystrixCommand.run() execution should be interrupted when a timeout occurs")
    @Configurable(value="swarm.hystrix.command.default.execution.isolation.thread.interruptOnTimeout")
    private Defaultable<Boolean> threadInterruptOnTimeout = Defaultable.bool((boolean)true);
    @AttributeDocumentation(value="Indicates whether the HystrixCommand.run() execution should be interrupted when a cancellation occurs")
    @Configurable(value="swarm.hystrix.command.default.execution.isolation.thread.interruptOnCancel")
    private Defaultable<Boolean> threadInterruptOnCancel = Defaultable.bool((boolean)false);
    @AttributeDocumentation(value="The maximum number of requests allowed to a HystrixCommand.run() method when you are using ExecutionIsolationStrategy.SEMAPHORE")
    @Configurable(value="swarm.hystrix.command.default.execution.isolation.semaphore.maxConcurrentRequests")
    private Defaultable<Integer> semaphorMaxConcurrentRequests = Defaultable.integer((int)10);
    @AttributeDocumentation(value="Determines whether a call to HystrixCommand.getFallback() will be attempted when failure or rejection occurs")
    @Configurable(value="swarm.hystrix.command.default.fallback.enabled")
    private Defaultable<Boolean> fallbackEnabled = Defaultable.bool((boolean)true);
    @AttributeDocumentation(value="Determines whether a circuit breaker will be used to track health and to short-circuit requests if it trips")
    @Configurable(value="swarm.hystrix.command.default.circuitBreaker.enabled")
    private Defaultable<Boolean> circuitBreakerEnabled = Defaultable.bool((boolean)true);
    @AttributeDocumentation(value="The minimum number of requests in a rolling window that will trip the circuit")
    @Configurable(value="swarm.hystrix.command.default.circuitBreaker.requestVolumeThreshold")
    private Defaultable<Integer> circuitBreakerRequestVolumeThreshold = Defaultable.integer((int)20);
    @AttributeDocumentation(value="The amount of time, after tripping the circuit, to reject requests before allowing attempts again to determine if the circuit should again be closed")
    @Configurable(value="swarm.hystrix.command.default.circuitBreaker.sleepWindowInMilliseconds")
    private Defaultable<Long> circuitBreakerSleepWindowInMilliseconds = Defaultable.longInteger((long)5000L);
    @AttributeDocumentation(value="The error percentage at or above which the circuit should trip open and start short-circuiting requests to fallback logic")
    @Configurable(value="swarm.hystrix.command.default.circuitBreaker.errorThresholdPercentage")
    private Defaultable<Integer> circuitBreakererrorThresholdPercentage = Defaultable.integer((int)50);
    @AttributeDocumentation(value="If true, forces the circuit breaker into an open (tripped) state in which it will reject all requests")
    @Configurable(value="swarm.hystrix.command.default.circuitBreaker.forceOpen")
    private Defaultable<Boolean> circuitBreakerForceOpen = Defaultable.bool((boolean)false);
    @AttributeDocumentation(value="If true, forces the circuit breaker into a closed state in which it will allow requests regardless of the error percentage")
    @Configurable(value="swarm.hystrix.command.default.circuitBreaker.forceClosed")
    private Defaultable<Boolean> circuitBreakerForceClosed = Defaultable.bool((boolean)false);
    @AttributeDocumentation(value="The duration of the statistical rolling window, in milliseconds. This is how long Hystrix keeps metrics for the circuit breaker to use and for publishing")
    @Configurable(value="swarm.hystrix.command.default.metrics.rollingStats.timeInMilliseconds")
    private Defaultable<Long> rollingStatsTimeInMilliseconds = Defaultable.longInteger((long)10000L);
    @AttributeDocumentation(value="The number of buckets the rolling statistical window is divided into")
    @Configurable(value="swarm.hystrix.command.default.metrics.rollingStats.numBuckets")
    private Defaultable<Integer> rollingStatsNumBuckets = Defaultable.integer((int)10);
    @AttributeDocumentation(value="Indicates whether execution latencies should be tracked and calculated as percentiles")
    @Configurable(value="swarm.hystrix.command.default.metrics.rollingPercentile.enabled")
    private Defaultable<Boolean> rollingPercentileEnabled = Defaultable.bool((boolean)true);
    @AttributeDocumentation(value="The duration of the rolling window in which execution times are kept to allow for percentile calculations, in milliseconds")
    @Configurable(value="swarm.hystrix.command.default.metrics.rollingPercentile.timeInMilliseconds")
    private Defaultable<Long> rollingPercentileTimeInMilliseconds = Defaultable.longInteger((long)60000L);
    @AttributeDocumentation(value="The number of buckets the rollingPercentile window will be divided into")
    @Configurable(value="swarm.hystrix.command.default.metrics.rollingPercentile.numBuckets")
    private Defaultable<Integer> rollingPercentileNumBuckets = Defaultable.integer((int)6);
    @AttributeDocumentation(value="The maximum number of execution times that are kept per bucket")
    @Configurable(value="swarm.hystrix.command.default.metrics.rollingPercentile.bucketSize")
    private Defaultable<Integer> rollingPercentileBucketSize = Defaultable.integer((int)100);
    @AttributeDocumentation(value="The time to wait, in milliseconds, between allowing health snapshots to be taken that calculate success and error percentages and affect circuit breaker status")
    @Configurable(value="swarm.hystrix.command.default.metrics.healthSnapshot.intervalInMilliseconds")
    private Defaultable<Long> healthSnapshotIntervalInMilliseconds = Defaultable.longInteger((long)500L);
    @AttributeDocumentation(value="Indicates whether HystrixCommand.getCacheKey() should be used with HystrixRequestCache to provide de-duplication functionality via request-scoped caching")
    @Configurable(value="swarm.hystrix.command.default.requestCache.enabled")
    private Defaultable<Boolean> requestCacheEnabled = Defaultable.bool((boolean)true);
    @AttributeDocumentation(value="Indicates whether HystrixCommand execution and events should be logged to HystrixRequestLog")
    @Configurable(value="swarm.hystrix.command.default.requestLog.enabled")
    private Defaultable<Boolean> requestLogEnabled = Defaultable.bool((boolean)true);
    @AttributeDocumentation(value="The maximum number of requests allowed in a batch before this triggers a batch execution")
    @Configurable(value="swarm.hystrix.collapser.default.maxRequestsInBatch")
    private Defaultable<Integer> maxRequestsInBatch = Defaultable.integer((int)Integer.MAX_VALUE);
    @AttributeDocumentation(value="The number of milliseconds after the creation of the batch that its execution is triggered")
    @Configurable(value="swarm.hystrix.collapser.default.timerDelayInMilliseconds")
    private Defaultable<Long> timerDelayInMilliseconds = Defaultable.longInteger((long)10L);
    @AttributeDocumentation(value="Indicates whether request caching is enabled for HystrixCollapser.execute() and HystrixCollapser.queue() invocations")
    @Configurable(value="swarm.hystrix.collapser.default.requestCache.enabled")
    private Defaultable<Boolean> collapserRequestCacheEnabled = Defaultable.bool((boolean)true);
    @AttributeDocumentation(value="The core thread-pool size")
    @Configurable(value="swarm.hystrix.threadpool.default.coreSize")
    private Defaultable<Integer> threadpoolCoreSize = Defaultable.integer((int)10);
    @AttributeDocumentation(value="The maximum thread-pool size")
    @Configurable(value="swarm.hystrix.threadpool.default.maximumSize")
    private Defaultable<Integer> threadpoolMaximumSize = Defaultable.integer((int)10);
    @AttributeDocumentation(value="The maximum queue size of the BlockingQueue implementation")
    @Configurable(value="swarm.hystrix.threadpool.default.maxQueueSize")
    private Defaultable<Integer> threadpoolMaxQueueSize = Defaultable.integer((int)-1);
    @AttributeDocumentation(value="The queue size rejection threshold \u2014 an artificial maximum queue size at which rejections will occur even if maxQueueSize has not been reached")
    @Configurable(value="swarm.hystrix.threadpool.default.queueSizeRejectionThreshold")
    private Defaultable<Integer> threadpoolQueueSizeRejectionThreshold = Defaultable.integer((int)5);
    @AttributeDocumentation(value="The keep-alive time, in minutes")
    @Configurable(value="swarm.hystrix.threadpool.default.keepAliveTimeMinutes")
    private Defaultable<Integer> threadpoolKeepAliveTimeMinutes = Defaultable.integer((int)1);
    @AttributeDocumentation(value="Allows the configuration for maximumSize to take effect")
    @Configurable(value="swarm.hystrix.threadpool.default.allowMaximumSizeToDivergeFromCoreSize")
    private Defaultable<Boolean> threadpoolKeepAllowMaximumSizeToDivergeFromCoreSize = Defaultable.bool((boolean)false);
    @AttributeDocumentation(value="The duration of the statistical rolling window, in milliseconds")
    @Configurable(value="swarm.hystrix.threadpool.default.metrics.rollingStats.timeInMilliseconds")
    private Defaultable<Long> threadPoolRollingStatsTimeInMilliseconds = Defaultable.longInteger((long)10000L);
    @AttributeDocumentation(value="The number of buckets the rolling statistical window is divided into")
    @Configurable(value="swarm.hystrix.threadpool.default.metrics.rollingPercentile.numBuckets")
    private Defaultable<Integer> threadpoolRollingPercentileNumBuckets = Defaultable.integer((int)10);

    public HystrixFraction streamPath(String streamPath) {
        this.streamPath.set((Object)streamPath);
        return this;
    }

    public String streamPath() {
        return (String)this.streamPath.get();
    }
}

