/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.infinispan;

import org.wildfly.swarm.config.Infinispan;
import org.wildfly.swarm.config.infinispan.Mode;
import org.wildfly.swarm.config.infinispan.cache_container.EvictionComponent;
import org.wildfly.swarm.config.infinispan.cache_container.LockingComponent;
import org.wildfly.swarm.config.infinispan.cache_container.TransactionComponent;
import org.wildfly.swarm.spi.api.Fraction;
import org.wildfly.swarm.spi.api.annotations.Configuration;
import org.wildfly.swarm.spi.api.annotations.Default;

@Configuration(extension="org.jboss.as.clustering.infinispan", marshal=true, parserFactoryClassName="org.wildfly.swarm.infinispan.runtime.ParserFactory")
public class InfinispanFraction
extends Infinispan<InfinispanFraction>
implements Fraction {
    private boolean defaultFraction = false;

    private InfinispanFraction() {
    }

    @Default
    public static InfinispanFraction createDefaultFraction() {
        return new InfinispanFraction().markDefaultFraction();
    }

    public void postInitialize(Fraction.PostInitContext initContext) {
        if (this.defaultFraction) {
            if (initContext.hasFraction("jgroups")) {
                this.clusteredDefaultFraction(initContext);
            } else {
                this.localDefaultFraction(initContext);
            }
        }
    }

    protected InfinispanFraction markDefaultFraction() {
        this.defaultFraction = true;
        return this;
    }

    private InfinispanFraction clusteredDefaultFraction(Fraction.PostInitContext initContext) {
        this.cacheContainer("server", cc -> cc.defaultCache("default").alias("singleton").alias("cluster").jgroupsTransport(t -> t.lockTimeout(Long.valueOf(60000L))).replicatedCache("default", c -> c.mode(Mode.SYNC).transactionComponent(t -> t.mode(TransactionComponent.Mode.BATCH))));
        if (initContext.hasFraction("undertow")) {
            this.cacheContainer("web", cc -> cc.defaultCache("dist").jgroupsTransport(t -> t.lockTimeout(Long.valueOf(60000L))).distributedCache("dist", c -> c.mode(Mode.ASYNC).l1Lifespan(Long.valueOf(0L)).owners(Integer.valueOf(2)).lockingComponent(lc -> lc.isolation(LockingComponent.Isolation.REPEATABLE_READ)).transactionComponent(tc -> tc.mode(TransactionComponent.Mode.BATCH)).fileStore()));
        }
        if (initContext.hasFraction("ejb")) {
            this.cacheContainer("ejb", cc -> cc.defaultCache("dist").alias("sfsb").jgroupsTransport(t -> t.lockTimeout(Long.valueOf(60000L))).distributedCache("dist", c -> c.mode(Mode.ASYNC).l1Lifespan(Long.valueOf(0L)).owners(Integer.valueOf(2)).lockingComponent(lc -> lc.isolation(LockingComponent.Isolation.REPEATABLE_READ)).transactionComponent(t -> t.mode(TransactionComponent.Mode.BATCH)).fileStore()));
        }
        if (initContext.hasFraction("jpa")) {
            this.cacheContainer("hibernate", cc -> cc.defaultCache("local-query").jgroupsTransport(t -> t.lockTimeout(Long.valueOf(60000L))).localCache("local-query", c -> c.evictionComponent(ec -> ec.maxEntries(Long.valueOf(10000L)).strategy(EvictionComponent.Strategy.LRU)).expirationComponent(ec -> ec.maxIdle(Long.valueOf(100000L)))).invalidationCache("entity", c -> c.mode(Mode.SYNC).transactionComponent(tc -> tc.mode(TransactionComponent.Mode.NON_XA)).evictionComponent(ec -> ec.maxEntries(Long.valueOf(10000L)).strategy(EvictionComponent.Strategy.LRU)).expirationComponent(ec -> ec.maxIdle(Long.valueOf(100000L)))).replicatedCache("timestamps", c -> c.mode(Mode.ASYNC)));
        }
        return this;
    }

    private InfinispanFraction localDefaultFraction(Fraction.PostInitContext initContext) {
        this.cacheContainer("server", cc -> cc.defaultCache("default").localCache("default", c -> c.transactionComponent(t -> t.mode(TransactionComponent.Mode.BATCH))).remoteCommandThreadPool());
        if (initContext.hasFraction("undertow")) {
            this.cacheContainer("web", cc -> cc.defaultCache("passivation").localCache("passivation", c -> c.lockingComponent(lc -> lc.isolation(LockingComponent.Isolation.REPEATABLE_READ)).transactionComponent(tc -> tc.mode(TransactionComponent.Mode.BATCH)).fileStore(fs -> fs.passivation(Boolean.valueOf(true)).purge(Boolean.valueOf(false)))).localCache("persistent", c -> c.lockingComponent(lc -> lc.isolation(LockingComponent.Isolation.REPEATABLE_READ)).transactionComponent(tc -> tc.mode(TransactionComponent.Mode.BATCH)).fileStore(fs -> fs.passivation(Boolean.valueOf(false)).purge(Boolean.valueOf(false)))));
        }
        if (initContext.hasFraction("ejb")) {
            this.cacheContainer("ejb", cc -> cc.alias("sfsb").defaultCache("passivation").localCache("passivation", c -> c.lockingComponent(lc -> lc.isolation(LockingComponent.Isolation.REPEATABLE_READ)).transactionComponent(tc -> tc.mode(TransactionComponent.Mode.BATCH)).fileStore(fs -> fs.passivation(Boolean.valueOf(true)).purge(Boolean.valueOf(false)))).localCache("persistent", c -> c.lockingComponent(lc -> lc.isolation(LockingComponent.Isolation.REPEATABLE_READ)).transactionComponent(tc -> tc.mode(TransactionComponent.Mode.BATCH)).fileStore(fs -> fs.passivation(Boolean.valueOf(false)).purge(Boolean.valueOf(false)))));
        }
        if (initContext.hasFraction("jpa")) {
            this.cacheContainer("hibernate", cc -> cc.defaultCache("local-query").localCache("entity", c -> c.transactionComponent(t -> t.mode(TransactionComponent.Mode.NON_XA)).evictionComponent(e -> e.strategy(EvictionComponent.Strategy.LRU).maxEntries(Long.valueOf(10000L))).expirationComponent(e -> e.maxIdle(Long.valueOf(100000L)))).localCache("immutable-entity", c -> c.transactionComponent(t -> t.mode(TransactionComponent.Mode.NON_XA)).evictionComponent(e -> e.strategy(EvictionComponent.Strategy.LRU).maxEntries(Long.valueOf(10000L))).expirationComponent(e -> e.maxIdle(Long.valueOf(100000L)))).localCache("local-query", c -> c.transactionComponent(t -> t.mode(TransactionComponent.Mode.NON_XA)).evictionComponent(e -> e.strategy(EvictionComponent.Strategy.LRU).maxEntries(Long.valueOf(10000L))).expirationComponent(e -> e.maxIdle(Long.valueOf(100000L)))).localCache("timestamps"));
        }
        return this;
    }
}

