/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.infinispan.runtime;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.jboss.msc.service.ServiceActivator;
import org.wildfly.swarm.config.EJB3;
import org.wildfly.swarm.config.JGroups;
import org.wildfly.swarm.config.JPA;
import org.wildfly.swarm.config.Undertow;
import org.wildfly.swarm.config.infinispan.Mode;
import org.wildfly.swarm.config.infinispan.cache_container.EvictionComponent;
import org.wildfly.swarm.config.infinispan.cache_container.LockingComponent;
import org.wildfly.swarm.config.infinispan.cache_container.TransactionComponent;
import org.wildfly.swarm.infinispan.InfinispanFraction;
import org.wildfly.swarm.infinispan.runtime.CacheActivator;
import org.wildfly.swarm.spi.api.Customizer;
import org.wildfly.swarm.spi.runtime.annotations.Post;

@Post
@ApplicationScoped
public class InfinispanCustomizer
implements Customizer {
    private static final String DEFAULT = "default";
    private static final String DIST = "dist";
    private static final String LOCAL_QUERY = "local-query";
    private static final String PASSIVATION = "passivation";
    @Inject
    private InfinispanFraction fraction;
    @Inject
    private Instance<JGroups> jgroups;
    @Inject
    private Instance<Undertow> undertow;
    @Inject
    private Instance<EJB3> ejb;
    @Inject
    private Instance<JPA> jpa;

    public void customize() {
        if (this.fraction.isDefaultFraction()) {
            if (!this.jgroups.isUnsatisfied()) {
                this.clusteredCustomization();
            } else {
                this.localCustomization();
            }
        }
    }

    private void clusteredCustomization() {
        this.fraction.cacheContainer("server", cc -> cc.defaultCache(DEFAULT).alias("singleton").alias("cluster").module("org.wildfly.clustering.server").jgroupsTransport(t -> t.lockTimeout(Long.valueOf(60000L))).replicatedCache(DEFAULT, c -> c.mode(Mode.SYNC).transactionComponent(t -> t.mode(TransactionComponent.Mode.BATCH))));
        if (!this.undertow.isUnsatisfied()) {
            this.fraction.cacheContainer("web", cc -> cc.defaultCache(DIST).jgroupsTransport(t -> t.lockTimeout(Long.valueOf(60000L))).distributedCache(DIST, c -> c.mode(Mode.ASYNC).l1Lifespan(Long.valueOf(0L)).owners(Integer.valueOf(2)).lockingComponent(lc -> lc.isolation(LockingComponent.Isolation.REPEATABLE_READ)).transactionComponent(tc -> tc.mode(TransactionComponent.Mode.BATCH)).fileStore()));
        }
        if (!this.ejb.isUnsatisfied()) {
            this.fraction.cacheContainer("ejb", cc -> cc.defaultCache(DIST).alias("sfsb").jgroupsTransport(t -> t.lockTimeout(Long.valueOf(60000L))).distributedCache(DIST, c -> c.mode(Mode.ASYNC).l1Lifespan(Long.valueOf(0L)).owners(Integer.valueOf(2)).lockingComponent(lc -> lc.isolation(LockingComponent.Isolation.REPEATABLE_READ)).transactionComponent(t -> t.mode(TransactionComponent.Mode.BATCH)).fileStore()));
        }
        if (!this.jpa.isUnsatisfied()) {
            this.fraction.cacheContainer("hibernate", cc -> cc.defaultCache(LOCAL_QUERY).module("org.hibernate.infinispan").jgroupsTransport(t -> t.lockTimeout(Long.valueOf(60000L))).localCache(LOCAL_QUERY, c -> c.evictionComponent(ec -> ec.maxEntries(Long.valueOf(10000L)).strategy(EvictionComponent.Strategy.LRU)).expirationComponent(ec -> ec.maxIdle(Long.valueOf(100000L)))).invalidationCache("entity", c -> c.mode(Mode.SYNC).transactionComponent(tc -> tc.mode(TransactionComponent.Mode.NON_XA)).evictionComponent(ec -> ec.maxEntries(Long.valueOf(10000L)).strategy(EvictionComponent.Strategy.LRU)).expirationComponent(ec -> ec.maxIdle(Long.valueOf(100000L)))).replicatedCache("timestamps", c -> c.mode(Mode.ASYNC)));
        }
    }

    private void localCustomization() {
        this.fraction.cacheContainer("server", cc -> cc.defaultCache(DEFAULT).module("org.wildfly.clustering.server").localCache(DEFAULT, c -> c.transactionComponent(t -> t.mode(TransactionComponent.Mode.BATCH))).remoteCommandThreadPool());
        if (!this.undertow.isUnsatisfied()) {
            this.fraction.cacheContainer("web", cc -> cc.defaultCache(PASSIVATION).localCache(PASSIVATION, c -> c.lockingComponent(lc -> lc.isolation(LockingComponent.Isolation.REPEATABLE_READ)).transactionComponent(tc -> tc.mode(TransactionComponent.Mode.BATCH)).fileStore(fs -> fs.passivation(Boolean.valueOf(true)).purge(Boolean.valueOf(false)))).localCache("persistent", c -> c.lockingComponent(lc -> lc.isolation(LockingComponent.Isolation.REPEATABLE_READ)).transactionComponent(tc -> tc.mode(TransactionComponent.Mode.BATCH)).fileStore(fs -> fs.passivation(Boolean.valueOf(false)).purge(Boolean.valueOf(false)))));
        }
        if (!this.ejb.isUnsatisfied()) {
            this.fraction.cacheContainer("ejb", cc -> cc.alias("sfsb").defaultCache(PASSIVATION).localCache(PASSIVATION, c -> c.lockingComponent(lc -> lc.isolation(LockingComponent.Isolation.REPEATABLE_READ)).transactionComponent(tc -> tc.mode(TransactionComponent.Mode.BATCH)).fileStore(fs -> fs.passivation(Boolean.valueOf(true)).purge(Boolean.valueOf(false)))).localCache("persistent", c -> c.lockingComponent(lc -> lc.isolation(LockingComponent.Isolation.REPEATABLE_READ)).transactionComponent(tc -> tc.mode(TransactionComponent.Mode.BATCH)).fileStore(fs -> fs.passivation(Boolean.valueOf(false)).purge(Boolean.valueOf(false)))));
        }
        if (!this.jpa.isUnsatisfied()) {
            this.fraction.cacheContainer("hibernate", cc -> cc.defaultCache(LOCAL_QUERY).module("org.hibernate.infinispan").localCache("entity", c -> c.transactionComponent(t -> t.mode(TransactionComponent.Mode.NON_XA)).evictionComponent(e -> e.strategy(EvictionComponent.Strategy.LRU).maxEntries(Long.valueOf(10000L))).expirationComponent(e -> e.maxIdle(Long.valueOf(100000L)))).localCache("immutable-entity", c -> c.transactionComponent(t -> t.mode(TransactionComponent.Mode.NON_XA)).evictionComponent(e -> e.strategy(EvictionComponent.Strategy.LRU).maxEntries(Long.valueOf(10000L))).expirationComponent(e -> e.maxIdle(Long.valueOf(100000L)))).localCache(LOCAL_QUERY, c -> c.transactionComponent(t -> t.mode(TransactionComponent.Mode.NON_XA)).evictionComponent(e -> e.strategy(EvictionComponent.Strategy.LRU).maxEntries(Long.valueOf(10000L))).expirationComponent(e -> e.maxIdle(Long.valueOf(100000L)))).localCache("timestamps"));
        }
    }

    @Produces
    @ApplicationScoped
    public ServiceActivator defaultActivator() {
        return new CacheActivator("server");
    }

    @Produces
    @ApplicationScoped
    public ServiceActivator undertowActivator() {
        return new CacheActivator("undertow");
    }

    @Produces
    @ApplicationScoped
    public ServiceActivator ejbActivator() {
        return new CacheActivator("ejb");
    }

    @Produces
    @ApplicationScoped
    public ServiceActivator jpaActivator() {
        return new CacheActivator("jpa");
    }
}

