/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.client.jaxrs;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.enterprise.concurrent.ManagedExecutorService;
import javax.naming.InitialContext;

public interface ServiceClient<T> {
    default public <U> void exec(Supplier<U> restMethod, Consumer<U> handler, Consumer<Throwable> exceptionHandler) throws Exception {
        ((CompletableFuture)this.chainableExec(restMethod, exceptionHandler).thenAccept((Consumer)handler)).exceptionally(t -> {
            exceptionHandler.accept((Throwable)t);
            return null;
        });
    }

    default public <U> CompletableFuture<U> chainableExec(Supplier<U> restMethod, Consumer<Throwable> exceptionHandler) throws Exception {
        return CompletableFuture.supplyAsync(restMethod, (Executor)this.executorService()).exceptionally(t -> {
            exceptionHandler.accept((Throwable)t);
            return null;
        });
    }

    default public ManagedExecutorService executorService() throws Exception {
        InitialContext ctx = new InitialContext();
        return (ManagedExecutorService)ctx.lookup("java:jboss/ee/concurrency/executor/default");
    }
}

