/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.jaxrs.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.logging.Logger;
import javax.ws.rs.core.Application;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchiveEvent;
import org.jboss.shrinkwrap.api.ArchiveEventHandler;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.ArchiveAsset;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ByteArrayAsset;
import org.jboss.shrinkwrap.impl.base.container.WebContainerBase;
import org.jboss.shrinkwrap.impl.base.spec.WebArchiveImpl;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.wildfly.swarm.jaxrs.JAXRSArchive;
import org.wildfly.swarm.jaxrs.JAXRSMessages;
import org.wildfly.swarm.jaxrs.internal.ApplicationFactory2;
import org.wildfly.swarm.jaxrs.internal.ApplicationPathAnnotationSeekingClassVisitor;
import org.wildfly.swarm.jaxrs.internal.JAXRSAnnotationSeekingClassVisitor;
import org.wildfly.swarm.undertow.descriptors.WebXmlAsset;

public class JAXRSArchiveImpl
extends WebContainerBase<JAXRSArchive>
implements JAXRSArchive {
    private static final Logger log = Logger.getLogger(WebArchiveImpl.class.getName());
    private static final ArchivePath PATH_WEB = ArchivePaths.root();
    private static final ArchivePath PATH_WEB_INF = ArchivePaths.create((String)"WEB-INF");
    private static final ArchivePath PATH_WEB_XML = ArchivePaths.create((ArchivePath)PATH_WEB_INF, (String)"web.xml");
    private static final ArchivePath PATH_RESOURCE = ArchivePaths.create((ArchivePath)PATH_WEB_INF, (String)"classes");
    private static final ArchivePath PATH_LIBRARY = ArchivePaths.create((ArchivePath)PATH_WEB_INF, (String)"lib");
    private static final ArchivePath PATH_CLASSES = ArchivePaths.create((ArchivePath)PATH_WEB_INF, (String)"classes");
    private static final ArchivePath PATH_MANIFEST = ArchivePaths.create((String)"META-INF");
    private static final ArchivePath PATH_SERVICE_PROVIDERS = ArchivePaths.create((ArchivePath)PATH_CLASSES, (String)"META-INF/services");

    public JAXRSArchiveImpl(Archive<?> delegate) throws IOException {
        super(JAXRSArchive.class, delegate);
        this.addGeneratedApplication();
        this.addFaviconExceptionHandler();
    }

    @Override
    public JAXRSArchive addResource(Class<?> resource) {
        this.addClass(resource);
        return (JAXRSArchive)this.covarientReturn();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean hasApplicationPathAnnotation(ArchivePath path, Asset asset) {
        if (asset == null) {
            return false;
        }
        if (asset instanceof ArchiveAsset) {
            return JAXRSArchiveImpl.hasApplicationPathAnnotation(((ArchiveAsset)asset).getArchive());
        }
        if (!path.get().endsWith(".class")) {
            return false;
        }
        try (InputStream in = asset.openStream();){
            ClassReader reader = new ClassReader(in);
            ApplicationPathAnnotationSeekingClassVisitor visitor = new ApplicationPathAnnotationSeekingClassVisitor();
            reader.accept((ClassVisitor)visitor, 0);
            boolean bl = visitor.isFound();
            return bl;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private static boolean hasApplicationPathAnnotation(Archive<?> archive) {
        Map content = archive.getContent();
        for (Map.Entry entry : content.entrySet()) {
            Node node = (Node)entry.getValue();
            Asset asset = node.getAsset();
            if (!JAXRSArchiveImpl.hasApplicationPathAnnotation(node.getPath(), asset)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasApplicationServletMapping(Archive<?> archive) {
        Node webXmlNode = archive.get(PATH_WEB_XML);
        if (webXmlNode != null) {
            return JAXRSArchiveImpl.hasApplicationServletMapping(webXmlNode.getAsset());
        }
        return false;
    }

    private static boolean hasApplicationServletMapping(Asset asset) {
        WebXmlAsset webXmlAsset;
        if (asset == null) {
            return false;
        }
        if (asset instanceof WebXmlAsset) {
            webXmlAsset = (WebXmlAsset)asset;
        } else {
            try {
                webXmlAsset = new WebXmlAsset(asset.openStream());
            }
            catch (Exception e) {
                JAXRSMessages.MESSAGES.unableToParseWebXml(e);
                return false;
            }
        }
        return !webXmlAsset.getServletMapping(Application.class.getName()).isEmpty();
    }

    private boolean hasApplicationPathOrServletMapping(Archive<?> archive) {
        return JAXRSArchiveImpl.hasApplicationServletMapping(archive) || JAXRSArchiveImpl.hasApplicationPathAnnotation(archive);
    }

    protected void addGeneratedApplication() throws IOException {
        if (!this.hasApplicationPathOrServletMapping(this.getArchive())) {
            String name = "org.wildfly.swarm.generated.WildFlySwarmDefaultJAXRSApplication";
            String path = "WEB-INF/classes/" + name.replace('.', '/') + ".class";
            byte[] generatedApp = ApplicationFactory2.create(name, "/");
            this.add((Asset)new ByteArrayAsset(generatedApp), path);
            this.addHandlers(new ArchiveEventHandler[]{new ApplicationHandler(this, path)});
        }
    }

    protected ArchivePath getManifestPath() {
        return PATH_MANIFEST;
    }

    protected ArchivePath getClassesPath() {
        return PATH_CLASSES;
    }

    protected ArchivePath getResourcePath() {
        return PATH_RESOURCE;
    }

    public static boolean isJAXRS(Archive<?> archive) {
        Map content = archive.getContent();
        for (Map.Entry entry : content.entrySet()) {
            Node node = (Node)entry.getValue();
            Asset asset = node.getAsset();
            if (!JAXRSArchiveImpl.isJAXRS(node.getPath(), asset)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isJAXRS(ArchivePath path, Asset asset) {
        if (asset == null) {
            return false;
        }
        if (asset instanceof ArchiveAsset) {
            return JAXRSArchiveImpl.isJAXRS(((ArchiveAsset)asset).getArchive());
        }
        if (!path.get().endsWith(".class")) {
            return false;
        }
        try (InputStream in = asset.openStream();){
            ClassReader reader = new ClassReader(in);
            JAXRSAnnotationSeekingClassVisitor visitor = new JAXRSAnnotationSeekingClassVisitor();
            reader.accept((ClassVisitor)visitor, 0);
            boolean bl = visitor.isFound();
            return bl;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    protected ArchivePath getLibraryPath() {
        return PATH_LIBRARY;
    }

    protected ArchivePath getWebPath() {
        return PATH_WEB;
    }

    protected ArchivePath getWebInfPath() {
        return PATH_WEB_INF;
    }

    protected ArchivePath getServiceProvidersPath() {
        return PATH_SERVICE_PROVIDERS;
    }

    public static class ApplicationHandler
    implements ArchiveEventHandler {
        private final JAXRSArchive archive;
        private final String path;

        public ApplicationHandler(JAXRSArchive archive, String path) {
            this.archive = archive;
            this.path = path;
        }

        public void handle(ArchiveEvent event) {
            Asset asset = event.getAsset();
            if (PATH_WEB_XML.equals(event.getPath()) && JAXRSArchiveImpl.hasApplicationServletMapping(asset) || JAXRSArchiveImpl.hasApplicationPathAnnotation(event.getPath(), asset)) {
                this.archive.delete(this.path);
            }
        }
    }
}

