/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.jaxrs.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.core.Application;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchiveEventHandler;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.ArchiveAsset;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ByteArrayAsset;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.container.runtime.cdi.DeploymentContext;
import org.wildfly.swarm.jaxrs.JAXRSArchive;
import org.wildfly.swarm.jaxrs.JAXRSMessages;
import org.wildfly.swarm.jaxrs.runtime.ApplicationHandler;
import org.wildfly.swarm.jaxrs.runtime.ApplicationPathAnnotationSeekingClassVisitor;
import org.wildfly.swarm.jaxrs.runtime.DefaultApplicationFactory;
import org.wildfly.swarm.spi.api.Defaultable;
import org.wildfly.swarm.spi.api.DeploymentProcessor;
import org.wildfly.swarm.spi.api.annotations.Configurable;
import org.wildfly.swarm.spi.runtime.annotations.DeploymentScoped;
import org.wildfly.swarm.undertow.descriptors.WebXmlAsset;

@DeploymentScoped
public class DefaultApplicationDeploymentProcessor
implements DeploymentProcessor {
    static final ArchivePath PATH_WEB_XML = ArchivePaths.create((ArchivePath)ArchivePaths.create((String)"WEB-INF"), (String)"web.xml");
    @AttributeDocumentation(value="Set the JAX-RS application path. If set, WildFly Swarm will automatically generate a JAX-RS Application class and use this value as the @ApplicationPath")
    @Configurable(value="swarm.deployment.*.jaxrs.application-path")
    Defaultable<String> applicationPath = Defaultable.string((String)"/");
    private final Archive archive;
    @Inject
    DeploymentContext deploymentContext;

    @Inject
    public DefaultApplicationDeploymentProcessor(Archive archive) {
        this.archive = archive;
    }

    public void process() throws Exception {
        if (this.deploymentContext != null && this.deploymentContext.isImplicit()) {
            return;
        }
        if (!this.archive.getName().endsWith(".war")) {
            return;
        }
        if (this.hasApplicationPathOrServletMapping(this.archive)) {
            return;
        }
        if (this.applicationPath.isExplicit()) {
            this.addGeneratedApplication((JAXRSArchive)this.archive.as(JAXRSArchive.class));
        }
    }

    private void addGeneratedApplication(JAXRSArchive archive) {
        String name = "org.wildfly.swarm.generated.WildFlySwarmDefaultJAXRSApplication";
        String path = "WEB-INF/classes/" + name.replace('.', '/') + ".class";
        try {
            byte[] generatedApp = DefaultApplicationFactory.create(name, (String)this.applicationPath.get());
            archive.add((Asset)new ByteArrayAsset(generatedApp), path);
            archive.addHandlers(new ArchiveEventHandler[]{new ApplicationHandler(archive, path)});
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static boolean hasApplicationPathAnnotation(Archive<?> archive) {
        Map content = archive.getContent();
        for (Map.Entry entry : content.entrySet()) {
            Node node = (Node)entry.getValue();
            Asset asset = node.getAsset();
            if (!DefaultApplicationDeploymentProcessor.hasApplicationPathAnnotation(node.getPath(), asset)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean hasApplicationPathAnnotation(ArchivePath path, Asset asset) {
        if (asset == null) {
            return false;
        }
        if (asset instanceof ArchiveAsset) {
            return DefaultApplicationDeploymentProcessor.hasApplicationPathAnnotation(((ArchiveAsset)asset).getArchive());
        }
        if (!path.get().endsWith(".class")) {
            return false;
        }
        try (InputStream in = asset.openStream();){
            ClassReader reader = new ClassReader(in);
            ApplicationPathAnnotationSeekingClassVisitor visitor = new ApplicationPathAnnotationSeekingClassVisitor();
            reader.accept((ClassVisitor)visitor, 0);
            boolean bl = visitor.isFound();
            return bl;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private static boolean hasApplicationServletMapping(Archive<?> archive) {
        Node webXmlNode = archive.get(PATH_WEB_XML);
        if (webXmlNode != null) {
            return DefaultApplicationDeploymentProcessor.hasApplicationServletMapping(webXmlNode.getAsset());
        }
        return false;
    }

    static boolean hasApplicationServletMapping(Asset asset) {
        WebXmlAsset webXmlAsset;
        if (asset == null) {
            return false;
        }
        if (asset instanceof WebXmlAsset) {
            webXmlAsset = (WebXmlAsset)asset;
        } else {
            try {
                webXmlAsset = new WebXmlAsset(asset.openStream());
            }
            catch (Exception e) {
                JAXRSMessages.MESSAGES.unableToParseWebXml(e);
                return false;
            }
        }
        return !webXmlAsset.getServletMapping(Application.class.getName()).isEmpty();
    }

    private boolean hasApplicationPathOrServletMapping(Archive<?> archive) {
        return DefaultApplicationDeploymentProcessor.hasApplicationServletMapping(archive) || DefaultApplicationDeploymentProcessor.hasApplicationPathAnnotation(archive);
    }
}

