/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.jgroups;

import org.wildfly.swarm.config.JGroups;
import org.wildfly.swarm.spi.api.Environment;
import org.wildfly.swarm.spi.api.Fraction;
import org.wildfly.swarm.spi.api.SocketBinding;
import org.wildfly.swarm.spi.api.SwarmProperties;
import org.wildfly.swarm.spi.api.annotations.Configuration;
import org.wildfly.swarm.spi.api.annotations.Default;

@Configuration(marshal=true, extension="org.jboss.as.clustering.jgroups", parserFactoryClassName="org.wildfly.swarm.jgroups.runtime.ParserFactory")
public class JGroupsFraction
extends JGroups<JGroupsFraction>
implements Fraction {
    @Default
    public static JGroupsFraction defaultFraction() {
        if (Environment.openshift()) {
            return JGroupsFraction.defaultOpenShiftFraction();
        }
        return JGroupsFraction.defaultMulticastFraction();
    }

    public static JGroupsFraction defaultMulticastFraction() {
        return (JGroupsFraction)((JGroupsFraction)((JGroupsFraction)new JGroupsFraction().defaultChannel("swarm-jgroups")).stack("udp", s -> {
            s.transport("UDP", t -> t.socketBinding("jgroups-udp"));
            s.protocol("PING");
            s.protocol("MERGE3");
            s.protocol("FD_SOCK", p -> p.socketBinding("jgroups-udp-fd"));
            s.protocol("FD_ALL");
            s.protocol("VERIFY_SUSPECT");
            s.protocol("pbcast.NAKACK2");
            s.protocol("UNICAST3");
            s.protocol("pbcast.STABLE");
            s.protocol("pbcast.GMS");
            s.protocol("UFC");
            s.protocol("MFC");
            s.protocol("FRAG2");
            s.protocol("RSVP");
        })).channel("swarm-jgroups", c -> c.stack("udp"));
    }

    public static JGroupsFraction defaultOpenShiftFraction() {
        return (JGroupsFraction)((JGroupsFraction)((JGroupsFraction)new JGroupsFraction().defaultChannel("swarm-jgroups")).stack("tcp", s -> {
            s.transport("TCP", t -> t.socketBinding("jgroups-tcp"));
            s.protocol("openshift.KUBE_PING");
            s.protocol("MERGE3");
            s.protocol("FD_SOCK", p -> p.socketBinding("jgroups-tcp-fd"));
            s.protocol("FD_ALL");
            s.protocol("VERIFY_SUSPECT");
            s.protocol("pbcast.NAKACK2");
            s.protocol("UNICAST3");
            s.protocol("pbcast.STABLE");
            s.protocol("pbcast.GMS");
            s.protocol("MFC");
            s.protocol("FRAG2");
            s.protocol("RSVP");
        })).channel("swarm-jgroups", c -> c.stack("tcp"));
    }

    public void initialize(Fraction.InitContext initContext) {
        initContext.socketBinding(new SocketBinding("jgroups-udp").port(55200).multicastAddress(SwarmProperties.propertyVar((String)"swarm.default.multicast.address", (String)"230.0.0.4")).multicastPort(45688));
        initContext.socketBinding(new SocketBinding("jgroups-udp-fd").port(54200));
        initContext.socketBinding(new SocketBinding("jgroups-mping").port(0).multicastAddress(SwarmProperties.propertyVar((String)"swarm.default.multicast.address", (String)"230.0.0.4")).multicastPort(45700));
        initContext.socketBinding(new SocketBinding("jgroups-tcp").port(7600));
        initContext.socketBinding(new SocketBinding("jgroups-tcp-fd").port(57600));
    }
}

