/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.jgroups.runtime;

import javax.enterprise.inject.Any;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.wildfly.swarm.jgroups.JGroupsFraction;
import org.wildfly.swarm.spi.api.Customizer;
import org.wildfly.swarm.spi.api.SocketBinding;
import org.wildfly.swarm.spi.api.SocketBindingGroup;
import org.wildfly.swarm.spi.runtime.annotations.ConfigurationValue;
import org.wildfly.swarm.spi.runtime.annotations.Pre;

@Pre
@Singleton
public class JGroupsSocketBindingCustomizer
implements Customizer {
    @Inject
    @Named(value="standard-sockets")
    private SocketBindingGroup group;
    @Inject
    @ConfigurationValue(value="swarm.default.multicast.address")
    private String multicastAddress;
    @Inject
    @Any
    private JGroupsFraction fraction;

    public void customize() {
        String addr = this.multicastAddress != null ? this.multicastAddress : this.fraction.defaultMulticastAddress();
        this.group.socketBinding(new SocketBinding("jgroups-udp").port(55200).multicastAddress(addr).multicastPort(45688));
        this.group.socketBinding(new SocketBinding("jgroups-udp-fd").port(54200));
        this.group.socketBinding(new SocketBinding("jgroups-mping").port(0).multicastAddress(addr).multicastPort(45700));
        this.group.socketBinding(new SocketBinding("jgroups-tcp").port(7600));
        this.group.socketBinding(new SocketBinding("jgroups-tcp-fd").port(57600));
    }
}

