/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.jgroups;

import javax.annotation.PostConstruct;
import org.wildfly.swarm.config.JGroups;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.spi.api.Defaultable;
import org.wildfly.swarm.spi.api.Fraction;
import org.wildfly.swarm.spi.api.annotations.Configurable;
import org.wildfly.swarm.spi.api.annotations.MarshalDMR;
import org.wildfly.swarm.spi.api.annotations.WildFlyExtension;

@WildFlyExtension(module="org.jboss.as.clustering.jgroups")
@MarshalDMR
public class JGroupsFraction
extends JGroups<JGroupsFraction>
implements Fraction<JGroupsFraction> {
    @AttributeDocumentation(value="Default multicast address for JGroups")
    @Configurable(value="swarm.default.multicast.address")
    private Defaultable<String> defaultMulticastAddress = Defaultable.string((String)"230.0.0.4");

    @PostConstruct
    public void postConstruct() {
        this.applyDefaults();
    }

    public static JGroupsFraction defaultFraction() {
        return new JGroupsFraction().applyDefaults();
    }

    public static JGroupsFraction defaultMulticastFraction() {
        return new JGroupsFraction().applyMulticastDefaults();
    }

    public JGroupsFraction applyDefaults() {
        return this.applyMulticastDefaults();
    }

    public JGroupsFraction applyMulticastDefaults() {
        return (JGroupsFraction)((JGroupsFraction)((JGroupsFraction)this.defaultChannel("swarm-jgroups")).stack("udp", s -> {
            s.transport("UDP", t -> t.socketBinding("jgroups-udp"));
            s.protocol("PING");
            s.protocol("MERGE3");
            s.protocol("FD_SOCK", p -> p.socketBinding("jgroups-udp-fd"));
            s.protocol("FD_ALL");
            s.protocol("VERIFY_SUSPECT");
            s.protocol("pbcast.NAKACK2");
            s.protocol("UNICAST3");
            s.protocol("pbcast.STABLE");
            s.protocol("pbcast.GMS");
            s.protocol("UFC");
            s.protocol("MFC");
            s.protocol("FRAG2");
            s.protocol("RSVP");
        })).channel("swarm-jgroups", c -> c.stack("udp"));
    }

    public JGroupsFraction defaultMulticastAddress(String defaultMulticastAddress) {
        this.defaultMulticastAddress.set((Object)defaultMulticastAddress);
        return this;
    }

    public String defaultMulticastAddress() {
        return (String)this.defaultMulticastAddress.get();
    }
}

