/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.jmx.runtime;

import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.logging.Logger;
import org.wildfly.swarm.config.ManagementCoreService;
import org.wildfly.swarm.config.Undertow;
import org.wildfly.swarm.config.jmx.JMXRemotingConnector;
import org.wildfly.swarm.jmx.JMXFraction;
import org.wildfly.swarm.remoting.RemotingFraction;
import org.wildfly.swarm.spi.api.Customizer;
import org.wildfly.swarm.spi.runtime.annotations.Pre;

@Pre
@Singleton
public class JMXRemotingConnectorEndpointSelector
implements Customizer {
    private static Logger LOG = Logger.getLogger((String)"org.wildfly.swarm.jmx");
    @Inject
    private JMXFraction jmx;
    @Inject
    private Instance<ManagementCoreService> management;
    @Inject
    private Instance<Undertow> undertow;
    @Inject
    private RemotingFraction remoting;

    public void customize() {
        JMXRemotingConnector remotingConnector = this.jmx.subresources().jmxRemotingConnector();
        if (remotingConnector == null) {
            LOG.info((Object)"JMX not configured for remote access");
            return;
        }
        boolean requiresLegacyRemoting = false;
        if (remotingConnector.useManagementEndpoint() == null) {
            if (!this.management.isUnsatisfied()) {
                LOG.info((Object)"JMX configured for remote connector: implicitly using management interface");
                remotingConnector.useManagementEndpoint(Boolean.valueOf(true));
            } else if (!this.undertow.isUnsatisfied()) {
                LOG.info((Object)"JMX configured for remote connector: implicitly using standard interface");
                remotingConnector.useManagementEndpoint(Boolean.valueOf(false));
            } else {
                requiresLegacyRemoting = true;
            }
        } else if (remotingConnector.useManagementEndpoint().booleanValue() && this.management.isUnsatisfied()) {
            LOG.warn((Object)"JMX configured to use management endpoint, but org.wildfly.swarm:management not available. Disabling");
            this.jmx.jmxRemotingConnector(() -> null);
        } else if (this.undertow.isUnsatisfied()) {
            requiresLegacyRemoting = true;
        }
        if (requiresLegacyRemoting) {
            remotingConnector.useManagementEndpoint(Boolean.valueOf(false));
            LOG.info((Object)"JMX configured for remote connector but neither management nor http interfaces available. Using legacy remoting.");
            this.remoting.requireLegacyConnector(true);
        }
    }
}

