/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.jpa;

import org.wildfly.swarm.config.JPA;
import org.wildfly.swarm.datasources.DatasourcesFraction;
import org.wildfly.swarm.spi.api.Fraction;
import org.wildfly.swarm.spi.api.annotations.Configuration;
import org.wildfly.swarm.spi.api.annotations.Default;

@Configuration(marshal=true, extension="org.jboss.as.jpa", parserFactoryClassName="org.wildfly.swarm.jpa.jpa.ParserFactory")
public class JPAFraction
extends JPA<JPAFraction>
implements Fraction {
    private boolean inhibitDefaultDatasource = false;

    @Default
    public static JPAFraction createDefaultFraction() {
        return (JPAFraction)new JPAFraction().defaultExtendedPersistenceInheritance(JPA.DefaultExtendedPersistenceInheritance.DEEP);
    }

    public JPAFraction inhibitDefaultDatasource() {
        this.inhibitDefaultDatasource = true;
        return this;
    }

    public void initialize(Fraction.InitContext initContext) {
        if (!this.inhibitDefaultDatasource) {
            DatasourcesFraction datasources = (DatasourcesFraction)new DatasourcesFraction().jdbcDriver("h2", d -> {
                d.driverClassName("org.h2.Driver");
                d.xaDatasourceClass("org.h2.jdbcx.JdbcDataSource");
                d.driverModuleName("com.h2database.h2");
            }).dataSource("ExampleDS", ds -> {
                ds.driverName("h2");
                ds.connectionUrl("jdbc:h2:mem:test;DB_CLOSE_DELAY=-1;DB_CLOSE_ON_EXIT=FALSE");
                ds.userName("sa");
                ds.password("sa");
            });
            initContext.fraction((Fraction)datasources);
            System.err.println("setting default Datasource to ExampleDS");
            this.defaultDatasource("jboss/datasources/ExampleDS");
        }
    }
}

