/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.jpa.mysql;

import org.wildfly.swarm.config.JPA;
import org.wildfly.swarm.datasources.DatasourcesFraction;
import org.wildfly.swarm.spi.api.Fraction;
import org.wildfly.swarm.spi.api.annotations.Configuration;
import org.wildfly.swarm.spi.api.annotations.Default;

@Configuration(marshal=true, extension="org.jboss.as.jpa", parserFactoryClassName="org.wildfly.swarm.jpa.mysql.ParserFactory")
public class MySQLJPAFraction
extends JPA<MySQLJPAFraction>
implements Fraction {
    private boolean inhibitDefaultDatasource = false;

    @Default
    public static MySQLJPAFraction createDefaultFraction() {
        return (MySQLJPAFraction)new MySQLJPAFraction().defaultExtendedPersistenceInheritance(JPA.DefaultExtendedPersistenceInheritance.DEEP);
    }

    public MySQLJPAFraction inhibitDefaultDatasource() {
        this.inhibitDefaultDatasource = true;
        return this;
    }

    public void initialize(Fraction.InitContext initContext) {
        if (!this.inhibitDefaultDatasource) {
            DatasourcesFraction datasources = (DatasourcesFraction)new DatasourcesFraction().jdbcDriver("mysql", d -> {
                d.driverClassName("com.mysql.jdbc.Driver");
                d.xaDatasourceClass("com.mysql.jdbc.jdbc2.optional.MysqlXADataSource");
                d.driverModuleName("com.mysql");
            }).dataSource("ExampleDS", ds -> {
                ds.driverName("mysql");
                ds.connectionUrl("jdbc:mysql://localhost:3306/test");
                ds.userName("root");
                ds.password("root");
            });
            initContext.fraction((Fraction)datasources);
            this.defaultDatasource("jboss/datasources/ExampleDS");
        }
    }
}

