/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.jpa.mysql;

import org.wildfly.swarm.config.JPA;
import org.wildfly.swarm.datasources.DatasourcesFraction;
import org.wildfly.swarm.spi.api.Fraction;
import org.wildfly.swarm.spi.api.annotations.Configuration;
import org.wildfly.swarm.spi.api.annotations.Default;

@Configuration(marshal=true, extension="org.jboss.as.jpa")
public class MySQLJPAFraction
extends JPA<MySQLJPAFraction>
implements Fraction {
    private boolean inhibitDefaultDatasource = false;

    @Default
    public static MySQLJPAFraction createDefaultFraction() {
        return (MySQLJPAFraction)new MySQLJPAFraction().defaultExtendedPersistenceInheritance(JPA.DefaultExtendedPersistenceInheritance.DEEP);
    }

    public MySQLJPAFraction inhibitDefaultDatasource() {
        this.inhibitDefaultDatasource = true;
        return this;
    }

    public void initialize(Fraction.InitContext initContext) {
        if (!this.inhibitDefaultDatasource) {
            String dsName = System.getProperty("swarm.ds.name", "ExampleDS");
            String driverName = System.getProperty("swarm.jdbc.driver", "mysql");
            DatasourcesFraction datasources = (DatasourcesFraction)new DatasourcesFraction().jdbcDriver(driverName, d -> {
                d.driverClassName("com.mysql.jdbc.Driver");
                d.xaDatasourceClass("com.mysql.jdbc.jdbc2.optional.MysqlXADataSource");
                d.driverModuleName("com.mysql");
            }).dataSource(dsName, ds -> {
                ds.driverName(driverName);
                ds.connectionUrl(System.getProperty("swarm.ds.connection.url", "jdbc:mysql://localhost:3306/test"));
                ds.userName(System.getProperty("swarm.ds.username", "root"));
                ds.password(System.getProperty("swarm.ds.password", "root"));
            });
            initContext.fraction((Fraction)datasources);
            this.defaultDatasource("jboss/datasources/" + dsName);
        }
    }
}

