/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.jpa.postgresql;

import org.wildfly.swarm.config.JPA;
import org.wildfly.swarm.datasources.DatasourcesFraction;
import org.wildfly.swarm.spi.api.Fraction;
import org.wildfly.swarm.spi.api.annotations.Configuration;
import org.wildfly.swarm.spi.api.annotations.Default;

@Configuration(marshal=true, extension="org.jboss.as.jpa", parserFactoryClassName="org.wildfly.swarm.jpa.postgresql.ParserFactory")
public class PostgreSQLJPAFraction
extends JPA<PostgreSQLJPAFraction>
implements Fraction {
    private boolean inhibitDefaultDatasource = false;

    @Default
    public static PostgreSQLJPAFraction createDefaultFraction() {
        return (PostgreSQLJPAFraction)new PostgreSQLJPAFraction().defaultExtendedPersistenceInheritance(JPA.DefaultExtendedPersistenceInheritance.DEEP);
    }

    public PostgreSQLJPAFraction inhibitDefaultDatasource() {
        this.inhibitDefaultDatasource = true;
        return this;
    }

    public void initialize(Fraction.InitContext initContext) {
        if (!this.inhibitDefaultDatasource) {
            DatasourcesFraction datasources = (DatasourcesFraction)new DatasourcesFraction().jdbcDriver("postgresql", d -> {
                d.driverClassName("org.postgresql.Driver");
                d.xaDatasourceClass("org.postgresql.xa.PGXADataSource");
                d.driverModuleName("org.postgresql");
            }).dataSource("ExampleDS", ds -> {
                ds.driverName("postgresql");
                ds.connectionUrl("jdbc:postgresql://localhost:5432/test");
                ds.userName("postgres");
                ds.password("postgres");
            });
            initContext.fraction((Fraction)datasources);
            System.err.println("setting default Datasource to ExampleDS");
            this.defaultDatasource("jboss/datasources/ExampleDS");
        }
    }
}

