/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.jpa.postgresql;

import org.wildfly.swarm.config.JPA;
import org.wildfly.swarm.datasources.DatasourcesFraction;
import org.wildfly.swarm.spi.api.Fraction;
import org.wildfly.swarm.spi.api.annotations.Configuration;
import org.wildfly.swarm.spi.api.annotations.Default;

@Configuration(marshal=true, extension="org.jboss.as.jpa", parserFactoryClassName="org.wildfly.swarm.jpa.postgresql.ParserFactory")
public class PostgreSQLJPAFraction
extends JPA<PostgreSQLJPAFraction>
implements Fraction {
    private boolean inhibitDefaultDatasource = false;

    @Default
    public static PostgreSQLJPAFraction createDefaultFraction() {
        return (PostgreSQLJPAFraction)new PostgreSQLJPAFraction().defaultExtendedPersistenceInheritance(JPA.DefaultExtendedPersistenceInheritance.DEEP);
    }

    public PostgreSQLJPAFraction inhibitDefaultDatasource() {
        this.inhibitDefaultDatasource = true;
        return this;
    }

    public void initialize(Fraction.InitContext initContext) {
        if (!this.inhibitDefaultDatasource) {
            String dsName = System.getProperty("swarm.ds.name", "ExampleDS");
            String driverName = System.getProperty("swarm.jdbc.driver", "postgresql");
            DatasourcesFraction datasources = (DatasourcesFraction)new DatasourcesFraction().jdbcDriver(driverName, d -> {
                d.driverClassName("org.postgresql.Driver");
                d.xaDatasourceClass("org.postgresql.xa.PGXADataSource");
                d.driverModuleName("org.postgresql");
            }).dataSource(dsName, ds -> {
                ds.driverName(driverName);
                ds.connectionUrl(System.getProperty("swam.ds.connection.url", "jdbc:postgresql://localhost:5432/test"));
                ds.userName(System.getProperty("swarm.ds.username", "postgres"));
                ds.password(System.getProperty("swarm.ds.password", "postgres"));
            });
            initContext.fraction((Fraction)datasources);
            System.err.println("setting default Datasource to ExampleDS");
            this.defaultDatasource("jboss/datasources/" + dsName);
        }
    }
}

