/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.keycloak;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=keycloak/realm=*")
@ResourceType(value="realm")
public class Realm<T extends Realm<T>>
extends HashMap
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="SSL Setting")
    private Boolean allowAnyHostname;
    @AttributeDocumentation(value="Refresh token on every single web request")
    private Boolean alwaysRefreshToken;
    @AttributeDocumentation(value="Base URL of the Realm Auth Server")
    private String authServerUrl;
    @AttributeDocumentation(value="URL to use to make background calls to auth server")
    private String authServerUrlForBackendRequests;
    @AttributeDocumentation(value="n/a")
    private String clientKeyPassword;
    @AttributeDocumentation(value="n/a")
    private String clientKeystore;
    @AttributeDocumentation(value="n/a")
    private String clientKeystorePassword;
    @AttributeDocumentation(value="Connection pool size for the client used by the adapter")
    private Integer connectionPoolSize;
    @AttributeDocumentation(value="CORS allowed headers")
    private String corsAllowedHeaders;
    @AttributeDocumentation(value="CORS allowed methods")
    private String corsAllowedMethods;
    @AttributeDocumentation(value="CORS max-age header")
    private Integer corsMaxAge;
    @AttributeDocumentation(value="Adapter will not use a trust manager when making adapter HTTPS requests")
    private Boolean disableTrustManager;
    @AttributeDocumentation(value="Enable Keycloak CORS support")
    private Boolean enableCors;
    @AttributeDocumentation(value="Enable secure URL that exposes access token")
    private Boolean exposeToken;
    @AttributeDocumentation(value="token attribute to use to set Principal name")
    private String principalAttribute;
    @AttributeDocumentation(value="Public key of the realm")
    private String realmPublicKey;
    @AttributeDocumentation(value="Cluster setting")
    private Boolean registerNodeAtStartup;
    @AttributeDocumentation(value="how often to re-register node")
    private Integer registerNodePeriod;
    @AttributeDocumentation(value="Specify if SSL is required (valid values are all, external and none)")
    private String sslRequired;
    @AttributeDocumentation(value="cookie or session storage for auth session data")
    private String tokenStore;
    @AttributeDocumentation(value="Truststore used for adapter client HTTPS requests")
    private String truststore;
    @AttributeDocumentation(value="Password of the Truststore")
    private String truststorePassword;

    public Realm(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="allow-any-hostname")
    public Boolean allowAnyHostname() {
        return this.allowAnyHostname;
    }

    public T allowAnyHostname(Boolean value) {
        Boolean oldValue = this.allowAnyHostname;
        this.allowAnyHostname = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("allowAnyHostname", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="always-refresh-token")
    public Boolean alwaysRefreshToken() {
        return this.alwaysRefreshToken;
    }

    public T alwaysRefreshToken(Boolean value) {
        Boolean oldValue = this.alwaysRefreshToken;
        this.alwaysRefreshToken = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("alwaysRefreshToken", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="auth-server-url")
    public String authServerUrl() {
        return this.authServerUrl;
    }

    public T authServerUrl(String value) {
        String oldValue = this.authServerUrl;
        this.authServerUrl = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("authServerUrl", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="auth-server-url-for-backend-requests")
    public String authServerUrlForBackendRequests() {
        return this.authServerUrlForBackendRequests;
    }

    public T authServerUrlForBackendRequests(String value) {
        String oldValue = this.authServerUrlForBackendRequests;
        this.authServerUrlForBackendRequests = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("authServerUrlForBackendRequests", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="client-key-password")
    public String clientKeyPassword() {
        return this.clientKeyPassword;
    }

    public T clientKeyPassword(String value) {
        String oldValue = this.clientKeyPassword;
        this.clientKeyPassword = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("clientKeyPassword", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="client-keystore")
    public String clientKeystore() {
        return this.clientKeystore;
    }

    public T clientKeystore(String value) {
        String oldValue = this.clientKeystore;
        this.clientKeystore = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("clientKeystore", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="client-keystore-password")
    public String clientKeystorePassword() {
        return this.clientKeystorePassword;
    }

    public T clientKeystorePassword(String value) {
        String oldValue = this.clientKeystorePassword;
        this.clientKeystorePassword = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("clientKeystorePassword", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="connection-pool-size")
    public Integer connectionPoolSize() {
        return this.connectionPoolSize;
    }

    public T connectionPoolSize(Integer value) {
        Integer oldValue = this.connectionPoolSize;
        this.connectionPoolSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("connectionPoolSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="cors-allowed-headers")
    public String corsAllowedHeaders() {
        return this.corsAllowedHeaders;
    }

    public T corsAllowedHeaders(String value) {
        String oldValue = this.corsAllowedHeaders;
        this.corsAllowedHeaders = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("corsAllowedHeaders", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="cors-allowed-methods")
    public String corsAllowedMethods() {
        return this.corsAllowedMethods;
    }

    public T corsAllowedMethods(String value) {
        String oldValue = this.corsAllowedMethods;
        this.corsAllowedMethods = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("corsAllowedMethods", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="cors-max-age")
    public Integer corsMaxAge() {
        return this.corsMaxAge;
    }

    public T corsMaxAge(Integer value) {
        Integer oldValue = this.corsMaxAge;
        this.corsMaxAge = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("corsMaxAge", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="disable-trust-manager")
    public Boolean disableTrustManager() {
        return this.disableTrustManager;
    }

    public T disableTrustManager(Boolean value) {
        Boolean oldValue = this.disableTrustManager;
        this.disableTrustManager = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("disableTrustManager", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="enable-cors")
    public Boolean enableCors() {
        return this.enableCors;
    }

    public T enableCors(Boolean value) {
        Boolean oldValue = this.enableCors;
        this.enableCors = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("enableCors", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="expose-token")
    public Boolean exposeToken() {
        return this.exposeToken;
    }

    public T exposeToken(Boolean value) {
        Boolean oldValue = this.exposeToken;
        this.exposeToken = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("exposeToken", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="principal-attribute")
    public String principalAttribute() {
        return this.principalAttribute;
    }

    public T principalAttribute(String value) {
        String oldValue = this.principalAttribute;
        this.principalAttribute = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("principalAttribute", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="realm-public-key")
    public String realmPublicKey() {
        return this.realmPublicKey;
    }

    public T realmPublicKey(String value) {
        String oldValue = this.realmPublicKey;
        this.realmPublicKey = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("realmPublicKey", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="register-node-at-startup")
    public Boolean registerNodeAtStartup() {
        return this.registerNodeAtStartup;
    }

    public T registerNodeAtStartup(Boolean value) {
        Boolean oldValue = this.registerNodeAtStartup;
        this.registerNodeAtStartup = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("registerNodeAtStartup", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="register-node-period")
    public Integer registerNodePeriod() {
        return this.registerNodePeriod;
    }

    public T registerNodePeriod(Integer value) {
        Integer oldValue = this.registerNodePeriod;
        this.registerNodePeriod = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("registerNodePeriod", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="ssl-required")
    public String sslRequired() {
        return this.sslRequired;
    }

    public T sslRequired(String value) {
        String oldValue = this.sslRequired;
        this.sslRequired = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("sslRequired", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="token-store")
    public String tokenStore() {
        return this.tokenStore;
    }

    public T tokenStore(String value) {
        String oldValue = this.tokenStore;
        this.tokenStore = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("tokenStore", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="truststore")
    public String truststore() {
        return this.truststore;
    }

    public T truststore(String value) {
        String oldValue = this.truststore;
        this.truststore = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("truststore", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="truststore-password")
    public String truststorePassword() {
        return this.truststorePassword;
    }

    public T truststorePassword(String value) {
        String oldValue = this.truststorePassword;
        this.truststorePassword = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("truststorePassword", oldValue, value);
        }
        return (T)this;
    }
}

