/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.keycloak.Realm;
import org.wildfly.swarm.config.keycloak.RealmConsumer;
import org.wildfly.swarm.config.keycloak.RealmSupplier;
import org.wildfly.swarm.config.keycloak.SecureDeployment;
import org.wildfly.swarm.config.keycloak.SecureDeploymentConsumer;
import org.wildfly.swarm.config.keycloak.SecureDeploymentSupplier;
import org.wildfly.swarm.config.keycloak.SecureServer;
import org.wildfly.swarm.config.keycloak.SecureServerConsumer;
import org.wildfly.swarm.config.keycloak.SecureServerSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/subsystem=keycloak")
@ResourceType(value="subsystem")
@Implicit
public class Keycloak<T extends Keycloak<T>>
implements Keyed {
    private String key = "keycloak";
    private PropertyChangeSupport pcs;
    private KeycloakResources subresources = new KeycloakResources();

    public Keycloak() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public KeycloakResources subresources() {
        return this.subresources;
    }

    public T secureDeployments(List<SecureDeployment> value) {
        this.subresources.secureDeployments = value;
        return (T)this;
    }

    public T secureDeployment(SecureDeployment value) {
        this.subresources.secureDeployments.add(value);
        return (T)this;
    }

    public T secureDeployment(String childKey, SecureDeploymentConsumer consumer) {
        SecureDeployment child = new SecureDeployment(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.secureDeployment(child);
        return (T)this;
    }

    public T secureDeployment(String childKey) {
        this.secureDeployment(childKey, null);
        return (T)this;
    }

    public T secureDeployment(SecureDeploymentSupplier supplier) {
        this.secureDeployment(supplier.get());
        return (T)this;
    }

    public T secureServers(List<SecureServer> value) {
        this.subresources.secureServers = value;
        return (T)this;
    }

    public T secureServer(SecureServer value) {
        this.subresources.secureServers.add(value);
        return (T)this;
    }

    public T secureServer(String childKey, SecureServerConsumer consumer) {
        SecureServer child = new SecureServer(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.secureServer(child);
        return (T)this;
    }

    public T secureServer(String childKey) {
        this.secureServer(childKey, null);
        return (T)this;
    }

    public T secureServer(SecureServerSupplier supplier) {
        this.secureServer(supplier.get());
        return (T)this;
    }

    public T realms(List<Realm> value) {
        this.subresources.realms = value;
        return (T)this;
    }

    public T realm(Realm value) {
        this.subresources.realms.add(value);
        return (T)this;
    }

    public T realm(String childKey, RealmConsumer consumer) {
        Realm child = new Realm(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.realm(child);
        return (T)this;
    }

    public T realm(String childKey) {
        this.realm(childKey, null);
        return (T)this;
    }

    public T realm(RealmSupplier supplier) {
        this.realm(supplier.get());
        return (T)this;
    }

    public static class KeycloakResources {
        @ResourceDocumentation(value="A deployment secured by Keycloak")
        @SubresourceInfo(value="secureDeployment")
        private List<SecureDeployment> secureDeployments = new ArrayList<SecureDeployment>();
        @ResourceDocumentation(value="A deployment secured by Keycloak")
        @SubresourceInfo(value="secureServer")
        private List<SecureServer> secureServers = new ArrayList<SecureServer>();
        @ResourceDocumentation(value="A Keycloak realm.")
        @SubresourceInfo(value="realm")
        private List<Realm> realms = new ArrayList<Realm>();

        @Subresource
        public List<SecureDeployment> secureDeployments() {
            return this.secureDeployments;
        }

        public SecureDeployment secureDeployment(String key) {
            return this.secureDeployments.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<SecureServer> secureServers() {
            return this.secureServers;
        }

        public SecureServer secureServer(String key) {
            return this.secureServers.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<Realm> realms() {
            return this.realms;
        }

        public Realm realm(String key) {
            return this.realms.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

