/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.keycloak;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.keycloak.Credential;
import org.wildfly.swarm.config.keycloak.CredentialConsumer;
import org.wildfly.swarm.config.keycloak.CredentialSupplier;
import org.wildfly.swarm.config.keycloak.RedirectRewriteRule;
import org.wildfly.swarm.config.keycloak.RedirectRewriteRuleConsumer;
import org.wildfly.swarm.config.keycloak.RedirectRewriteRuleSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/subsystem=keycloak/secure-deployment=*")
@ResourceType(value="secure-deployment")
public class SecureDeployment<T extends SecureDeployment<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    private SecureDeploymentResources subresources = new SecureDeploymentResources();
    @AttributeDocumentation(value="SSL Setting")
    private Boolean allowAnyHostname;
    @AttributeDocumentation(value="Refresh token on every single web request")
    private Boolean alwaysRefreshToken;
    @AttributeDocumentation(value="Base URL of the Realm Auth Server")
    private String authServerUrl;
    @AttributeDocumentation(value="URL to use to make background calls to auth server")
    private String authServerUrlForBackendRequests;
    @AttributeDocumentation(value="autodetect bearer-only requests")
    private Boolean autodetectBearerOnly;
    @AttributeDocumentation(value="Bearer Token Auth only")
    private Boolean bearerOnly;
    @AttributeDocumentation(value="n/a")
    private String clientKeyPassword;
    @AttributeDocumentation(value="n/a")
    private String clientKeystore;
    @AttributeDocumentation(value="n/a")
    private String clientKeystorePassword;
    @AttributeDocumentation(value="Connection pool size for the client used by the adapter")
    private Integer connectionPoolSize;
    @AttributeDocumentation(value="CORS allowed headers")
    private String corsAllowedHeaders;
    @AttributeDocumentation(value="CORS allowed methods")
    private String corsAllowedMethods;
    @AttributeDocumentation(value="CORS exposed headers")
    private String corsExposedHeaders;
    @AttributeDocumentation(value="CORS max-age header")
    private Integer corsMaxAge;
    @AttributeDocumentation(value="Adapter will not use a trust manager when making adapter HTTPS requests")
    private Boolean disableTrustManager;
    @AttributeDocumentation(value="Enable Basic Authentication")
    private Boolean enableBasicAuth;
    @AttributeDocumentation(value="Enable Keycloak CORS support")
    private Boolean enableCors;
    @AttributeDocumentation(value="Enable secure URL that exposes access token")
    private Boolean exposeToken;
    @AttributeDocumentation(value="disable query parameter parsing for access_token")
    private Boolean ignoreOauthQueryParameter;
    @AttributeDocumentation(value="If adapter recognize token signed by unknown public key, it will try to download new public key from keycloak server. However it won't try to download if already tried it in less than 'min-time-between-jwks-requests' seconds")
    private Integer minTimeBetweenJwksRequests;
    @AttributeDocumentation(value="token attribute to use to set Principal name")
    private String principalAttribute;
    @AttributeDocumentation(value="Public client")
    private Boolean publicClient;
    @AttributeDocumentation(value="Keycloak realm")
    private String realm;
    @AttributeDocumentation(value="Public key of the realm")
    private String realmPublicKey;
    @AttributeDocumentation(value="Cluster setting")
    private Boolean registerNodeAtStartup;
    @AttributeDocumentation(value="how often to re-register node")
    private Integer registerNodePeriod;
    @AttributeDocumentation(value="Application name")
    private String resource;
    @AttributeDocumentation(value="Specify if SSL is required (valid values are all, external and none)")
    private String sslRequired;
    @AttributeDocumentation(value="The adapter will refresh the token if the current token is expired OR will expire in 'token-minimum-time-to-live' seconds or less")
    private Integer tokenMinimumTimeToLive;
    @AttributeDocumentation(value="cookie or session storage for auth session data")
    private String tokenStore;
    @AttributeDocumentation(value="Truststore used for adapter client HTTPS requests")
    private String truststore;
    @AttributeDocumentation(value="Password of the Truststore")
    private String truststorePassword;
    @AttributeDocumentation(value="The session id is changed by default on a successful login.  Change this to true if you want to turn this off")
    private Boolean turnOffChangeSessionIdOnLogin;
    @AttributeDocumentation(value="Use resource level permissions from token")
    private Boolean useResourceRoleMappings;

    public SecureDeployment(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public SecureDeploymentResources subresources() {
        return this.subresources;
    }

    public T credentials(List<Credential> value) {
        this.subresources.credentials = value;
        return (T)this;
    }

    public T credential(Credential value) {
        this.subresources.credentials.add(value);
        return (T)this;
    }

    public T credential(String childKey, CredentialConsumer consumer) {
        Credential child = new Credential(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.credential(child);
        return (T)this;
    }

    public T credential(String childKey) {
        this.credential(childKey, null);
        return (T)this;
    }

    public T credential(CredentialSupplier supplier) {
        this.credential(supplier.get());
        return (T)this;
    }

    public T redirectRewriteRules(List<RedirectRewriteRule> value) {
        this.subresources.redirectRewriteRules = value;
        return (T)this;
    }

    public T redirectRewriteRule(RedirectRewriteRule value) {
        this.subresources.redirectRewriteRules.add(value);
        return (T)this;
    }

    public T redirectRewriteRule(String childKey, RedirectRewriteRuleConsumer consumer) {
        RedirectRewriteRule child = new RedirectRewriteRule(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.redirectRewriteRule(child);
        return (T)this;
    }

    public T redirectRewriteRule(String childKey) {
        this.redirectRewriteRule(childKey, null);
        return (T)this;
    }

    public T redirectRewriteRule(RedirectRewriteRuleSupplier supplier) {
        this.redirectRewriteRule(supplier.get());
        return (T)this;
    }

    @ModelNodeBinding(detypedName="allow-any-hostname")
    public Boolean allowAnyHostname() {
        return this.allowAnyHostname;
    }

    public T allowAnyHostname(Boolean value) {
        Boolean oldValue = this.allowAnyHostname;
        this.allowAnyHostname = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("allowAnyHostname", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="always-refresh-token")
    public Boolean alwaysRefreshToken() {
        return this.alwaysRefreshToken;
    }

    public T alwaysRefreshToken(Boolean value) {
        Boolean oldValue = this.alwaysRefreshToken;
        this.alwaysRefreshToken = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("alwaysRefreshToken", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="auth-server-url")
    public String authServerUrl() {
        return this.authServerUrl;
    }

    public T authServerUrl(String value) {
        String oldValue = this.authServerUrl;
        this.authServerUrl = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("authServerUrl", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="auth-server-url-for-backend-requests")
    public String authServerUrlForBackendRequests() {
        return this.authServerUrlForBackendRequests;
    }

    public T authServerUrlForBackendRequests(String value) {
        String oldValue = this.authServerUrlForBackendRequests;
        this.authServerUrlForBackendRequests = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("authServerUrlForBackendRequests", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="autodetect-bearer-only")
    public Boolean autodetectBearerOnly() {
        return this.autodetectBearerOnly;
    }

    public T autodetectBearerOnly(Boolean value) {
        Boolean oldValue = this.autodetectBearerOnly;
        this.autodetectBearerOnly = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("autodetectBearerOnly", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="bearer-only")
    public Boolean bearerOnly() {
        return this.bearerOnly;
    }

    public T bearerOnly(Boolean value) {
        Boolean oldValue = this.bearerOnly;
        this.bearerOnly = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("bearerOnly", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="client-key-password")
    public String clientKeyPassword() {
        return this.clientKeyPassword;
    }

    public T clientKeyPassword(String value) {
        String oldValue = this.clientKeyPassword;
        this.clientKeyPassword = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("clientKeyPassword", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="client-keystore")
    public String clientKeystore() {
        return this.clientKeystore;
    }

    public T clientKeystore(String value) {
        String oldValue = this.clientKeystore;
        this.clientKeystore = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("clientKeystore", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="client-keystore-password")
    public String clientKeystorePassword() {
        return this.clientKeystorePassword;
    }

    public T clientKeystorePassword(String value) {
        String oldValue = this.clientKeystorePassword;
        this.clientKeystorePassword = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("clientKeystorePassword", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="connection-pool-size")
    public Integer connectionPoolSize() {
        return this.connectionPoolSize;
    }

    public T connectionPoolSize(Integer value) {
        Integer oldValue = this.connectionPoolSize;
        this.connectionPoolSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("connectionPoolSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="cors-allowed-headers")
    public String corsAllowedHeaders() {
        return this.corsAllowedHeaders;
    }

    public T corsAllowedHeaders(String value) {
        String oldValue = this.corsAllowedHeaders;
        this.corsAllowedHeaders = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("corsAllowedHeaders", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="cors-allowed-methods")
    public String corsAllowedMethods() {
        return this.corsAllowedMethods;
    }

    public T corsAllowedMethods(String value) {
        String oldValue = this.corsAllowedMethods;
        this.corsAllowedMethods = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("corsAllowedMethods", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="cors-exposed-headers")
    public String corsExposedHeaders() {
        return this.corsExposedHeaders;
    }

    public T corsExposedHeaders(String value) {
        String oldValue = this.corsExposedHeaders;
        this.corsExposedHeaders = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("corsExposedHeaders", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="cors-max-age")
    public Integer corsMaxAge() {
        return this.corsMaxAge;
    }

    public T corsMaxAge(Integer value) {
        Integer oldValue = this.corsMaxAge;
        this.corsMaxAge = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("corsMaxAge", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="disable-trust-manager")
    public Boolean disableTrustManager() {
        return this.disableTrustManager;
    }

    public T disableTrustManager(Boolean value) {
        Boolean oldValue = this.disableTrustManager;
        this.disableTrustManager = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("disableTrustManager", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="enable-basic-auth")
    public Boolean enableBasicAuth() {
        return this.enableBasicAuth;
    }

    public T enableBasicAuth(Boolean value) {
        Boolean oldValue = this.enableBasicAuth;
        this.enableBasicAuth = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("enableBasicAuth", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="enable-cors")
    public Boolean enableCors() {
        return this.enableCors;
    }

    public T enableCors(Boolean value) {
        Boolean oldValue = this.enableCors;
        this.enableCors = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("enableCors", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="expose-token")
    public Boolean exposeToken() {
        return this.exposeToken;
    }

    public T exposeToken(Boolean value) {
        Boolean oldValue = this.exposeToken;
        this.exposeToken = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("exposeToken", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="ignore-oauth-query-parameter")
    public Boolean ignoreOauthQueryParameter() {
        return this.ignoreOauthQueryParameter;
    }

    public T ignoreOauthQueryParameter(Boolean value) {
        Boolean oldValue = this.ignoreOauthQueryParameter;
        this.ignoreOauthQueryParameter = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("ignoreOauthQueryParameter", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="min-time-between-jwks-requests")
    public Integer minTimeBetweenJwksRequests() {
        return this.minTimeBetweenJwksRequests;
    }

    public T minTimeBetweenJwksRequests(Integer value) {
        Integer oldValue = this.minTimeBetweenJwksRequests;
        this.minTimeBetweenJwksRequests = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("minTimeBetweenJwksRequests", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="principal-attribute")
    public String principalAttribute() {
        return this.principalAttribute;
    }

    public T principalAttribute(String value) {
        String oldValue = this.principalAttribute;
        this.principalAttribute = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("principalAttribute", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="public-client")
    public Boolean publicClient() {
        return this.publicClient;
    }

    public T publicClient(Boolean value) {
        Boolean oldValue = this.publicClient;
        this.publicClient = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("publicClient", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="realm")
    public String realm() {
        return this.realm;
    }

    public T realm(String value) {
        String oldValue = this.realm;
        this.realm = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("realm", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="realm-public-key")
    public String realmPublicKey() {
        return this.realmPublicKey;
    }

    public T realmPublicKey(String value) {
        String oldValue = this.realmPublicKey;
        this.realmPublicKey = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("realmPublicKey", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="register-node-at-startup")
    public Boolean registerNodeAtStartup() {
        return this.registerNodeAtStartup;
    }

    public T registerNodeAtStartup(Boolean value) {
        Boolean oldValue = this.registerNodeAtStartup;
        this.registerNodeAtStartup = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("registerNodeAtStartup", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="register-node-period")
    public Integer registerNodePeriod() {
        return this.registerNodePeriod;
    }

    public T registerNodePeriod(Integer value) {
        Integer oldValue = this.registerNodePeriod;
        this.registerNodePeriod = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("registerNodePeriod", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="resource")
    public String resource() {
        return this.resource;
    }

    public T resource(String value) {
        String oldValue = this.resource;
        this.resource = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("resource", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="ssl-required")
    public String sslRequired() {
        return this.sslRequired;
    }

    public T sslRequired(String value) {
        String oldValue = this.sslRequired;
        this.sslRequired = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("sslRequired", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="token-minimum-time-to-live")
    public Integer tokenMinimumTimeToLive() {
        return this.tokenMinimumTimeToLive;
    }

    public T tokenMinimumTimeToLive(Integer value) {
        Integer oldValue = this.tokenMinimumTimeToLive;
        this.tokenMinimumTimeToLive = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("tokenMinimumTimeToLive", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="token-store")
    public String tokenStore() {
        return this.tokenStore;
    }

    public T tokenStore(String value) {
        String oldValue = this.tokenStore;
        this.tokenStore = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("tokenStore", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="truststore")
    public String truststore() {
        return this.truststore;
    }

    public T truststore(String value) {
        String oldValue = this.truststore;
        this.truststore = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("truststore", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="truststore-password")
    public String truststorePassword() {
        return this.truststorePassword;
    }

    public T truststorePassword(String value) {
        String oldValue = this.truststorePassword;
        this.truststorePassword = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("truststorePassword", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="turn-off-change-session-id-on-login")
    public Boolean turnOffChangeSessionIdOnLogin() {
        return this.turnOffChangeSessionIdOnLogin;
    }

    public T turnOffChangeSessionIdOnLogin(Boolean value) {
        Boolean oldValue = this.turnOffChangeSessionIdOnLogin;
        this.turnOffChangeSessionIdOnLogin = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("turnOffChangeSessionIdOnLogin", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="use-resource-role-mappings")
    public Boolean useResourceRoleMappings() {
        return this.useResourceRoleMappings;
    }

    public T useResourceRoleMappings(Boolean value) {
        Boolean oldValue = this.useResourceRoleMappings;
        this.useResourceRoleMappings = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("useResourceRoleMappings", oldValue, value);
        }
        return (T)this;
    }

    public static class SecureDeploymentResources {
        @ResourceDocumentation(value="Credential")
        @SubresourceInfo(value="credential")
        private List<Credential> credentials = new ArrayList<Credential>();
        @ResourceDocumentation(value="redirect-rewrite-rule")
        @SubresourceInfo(value="redirectRewriteRule")
        private List<RedirectRewriteRule> redirectRewriteRules = new ArrayList<RedirectRewriteRule>();

        @Subresource
        public List<Credential> credentials() {
            return this.credentials;
        }

        public Credential credential(String key) {
            return this.credentials.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<RedirectRewriteRule> redirectRewriteRules() {
            return this.redirectRewriteRules;
        }

        public RedirectRewriteRule redirectRewriteRule(String key) {
            return this.redirectRewriteRules.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

