package org.wildfly.swarm.config;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.keycloak.server.ThemeConsumer;
import org.wildfly.swarm.config.keycloak.server.ThemeSupplier;
import org.wildfly.swarm.config.keycloak.server.Theme;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.keycloak.server.SpiConsumer;
import org.wildfly.swarm.config.keycloak.server.SpiSupplier;
import org.wildfly.swarm.config.keycloak.server.Spi;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Arrays;

/**
 * Keycloak subsystem
 */
@Address("/subsystem=keycloak-server")
@ResourceType("subsystem")
@Implicit
public class KeycloakServer<T extends KeycloakServer<T>> extends HashMap
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private KeycloakServerResources subresources = new KeycloakServerResources();
	private String masterRealmName;
	private List<String> providers;
	private Long scheduledTaskInterval;
	private String webContext;

	public KeycloakServer() {
		super();
		this.key = "keycloak-server";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public KeycloakServerResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all Theme objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of Theme objects.
	 */
	@SuppressWarnings("unchecked")
	public T themes(java.util.List<Theme> value) {
		this.subresources.themes = value;
		return (T) this;
	}

	/**
	 * Add the Theme object to the list of subresources
	 * 
	 * @param value
	 *            The Theme to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T theme(Theme value) {
		this.subresources.themes.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a Theme object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Theme resource
	 * @param config
	 *            The ThemeConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T theme(java.lang.String childKey, ThemeConsumer consumer) {
		Theme<? extends Theme> child = new Theme<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		theme(child);
		return (T) this;
	}

	/**
	 * Create and configure a Theme object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Theme resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T theme(java.lang.String childKey) {
		theme(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied Theme object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T theme(ThemeSupplier supplier) {
		theme(supplier.get());
		return (T) this;
	}

	/**
	 * Add all Spi objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of Spi objects.
	 */
	@SuppressWarnings("unchecked")
	public T spis(java.util.List<Spi> value) {
		this.subresources.spis = value;
		return (T) this;
	}

	/**
	 * Add the Spi object to the list of subresources
	 * 
	 * @param value
	 *            The Spi to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T spi(Spi value) {
		this.subresources.spis.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a Spi object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Spi resource
	 * @param config
	 *            The SpiConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T spi(java.lang.String childKey, SpiConsumer consumer) {
		Spi<? extends Spi> child = new Spi<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		spi(child);
		return (T) this;
	}

	/**
	 * Create and configure a Spi object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Spi resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T spi(java.lang.String childKey) {
		spi(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied Spi object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T spi(SpiSupplier supplier) {
		spi(supplier.get());
		return (T) this;
	}

	/**
	 * Child mutators for KeycloakServer
	 */
	public static class KeycloakServerResources {
		/**
		 * Theme configuration properties.
		 */
		@SubresourceInfo("theme")
		private List<Theme> themes = new java.util.ArrayList<>();
		/**
		 * A Service Provider type.
		 */
		@SubresourceInfo("spi")
		private List<Spi> spis = new java.util.ArrayList<>();

		/**
		 * Get the list of Theme resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<Theme> themes() {
			return this.themes;
		}

		public Theme theme(java.lang.String key) {
			return this.themes.stream().filter(e -> e.getKey().equals(key))
					.findFirst().orElse(null);
		}
		/**
		 * Get the list of Spi resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<Spi> spis() {
			return this.spis;
		}

		public Spi spi(java.lang.String key) {
			return this.spis.stream().filter(e -> e.getKey().equals(key))
					.findFirst().orElse(null);
		}
	}

	/**
	 * The name of the master admin realm.
	 */
	@ModelNodeBinding(detypedName = "master-realm-name")
	public String masterRealmName() {
		return this.masterRealmName;
	}

	/**
	 * The name of the master admin realm.
	 */
	@SuppressWarnings("unchecked")
	public T masterRealmName(java.lang.String value) {
		Object oldValue = this.masterRealmName;
		this.masterRealmName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("masterRealmName", oldValue, value);
		return (T) this;
	}

	/**
	 * Paths to search for Keycloak provider jars.
	 */
	@ModelNodeBinding(detypedName = "providers")
	public List<String> providers() {
		return this.providers;
	}

	/**
	 * Paths to search for Keycloak provider jars.
	 */
	@SuppressWarnings("unchecked")
	public T providers(java.util.List<String> value) {
		Object oldValue = this.providers;
		this.providers = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("providers", oldValue, value);
		return (T) this;
	}

	/**
	 * Paths to search for Keycloak provider jars.
	 */
	@SuppressWarnings("unchecked")
	public T provider(String value) {
		if (this.providers == null) {
			this.providers = new java.util.ArrayList<>();
		}
		this.providers.add(value);
		return (T) this;
	}

	/**
	 * Paths to search for Keycloak provider jars.
	 */
	@SuppressWarnings("unchecked")
	public T providers(String... args) {
		providers(Arrays.asList(args));
		return (T) this;
	}

	/**
	 * The interval (in seconds) to run scheduled tasks.
	 */
	@ModelNodeBinding(detypedName = "scheduled-task-interval")
	public Long scheduledTaskInterval() {
		return this.scheduledTaskInterval;
	}

	/**
	 * The interval (in seconds) to run scheduled tasks.
	 */
	@SuppressWarnings("unchecked")
	public T scheduledTaskInterval(java.lang.Long value) {
		Object oldValue = this.scheduledTaskInterval;
		this.scheduledTaskInterval = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("scheduledTaskInterval", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Web context where Keycloak server is bound. Default value is 'auth'.
	 */
	@ModelNodeBinding(detypedName = "web-context")
	public String webContext() {
		return this.webContext;
	}

	/**
	 * Web context where Keycloak server is bound. Default value is 'auth'.
	 */
	@SuppressWarnings("unchecked")
	public T webContext(java.lang.String value) {
		Object oldValue = this.webContext;
		this.webContext = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("webContext", oldValue, value);
		return (T) this;
	}
}