package org.wildfly.swarm.config.keycloak.server;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Arrays;

/**
 * Theme configuration properties.
 */
@Address("/subsystem=keycloak-server/theme=*")
@ResourceType("theme")
public class Theme<T extends Theme<T>> extends HashMap
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private Boolean cachetemplates;
	private Boolean cachethemes;
	private String attributeDefault;
	private String dir;
	private List<String> modules;
	private Long staticmaxage;
	private String welcometheme;

	public Theme(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * If true, theme templates are cached.
	 */
	@ModelNodeBinding(detypedName = "cacheTemplates")
	public Boolean cachetemplates() {
		return this.cachetemplates;
	}

	/**
	 * If true, theme templates are cached.
	 */
	@SuppressWarnings("unchecked")
	public T cachetemplates(java.lang.Boolean value) {
		Object oldValue = this.cachetemplates;
		this.cachetemplates = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("cachetemplates", oldValue, value);
		return (T) this;
	}

	/**
	 * If true, themes are cached.
	 */
	@ModelNodeBinding(detypedName = "cacheThemes")
	public Boolean cachethemes() {
		return this.cachethemes;
	}

	/**
	 * If true, themes are cached.
	 */
	@SuppressWarnings("unchecked")
	public T cachethemes(java.lang.Boolean value) {
		Object oldValue = this.cachethemes;
		this.cachethemes = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("cachethemes", oldValue, value);
		return (T) this;
	}

	/**
	 * The default theme to use if no theme is specified for a realm.
	 */
	@ModelNodeBinding(detypedName = "default")
	public String attributeDefault() {
		return this.attributeDefault;
	}

	/**
	 * The default theme to use if no theme is specified for a realm.
	 */
	@SuppressWarnings("unchecked")
	public T attributeDefault(java.lang.String value) {
		Object oldValue = this.attributeDefault;
		this.attributeDefault = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("attributeDefault", oldValue, value);
		return (T) this;
	}

	/**
	 * Directory where themes can be located.
	 */
	@ModelNodeBinding(detypedName = "dir")
	public String dir() {
		return this.dir;
	}

	/**
	 * Directory where themes can be located.
	 */
	@SuppressWarnings("unchecked")
	public T dir(java.lang.String value) {
		Object oldValue = this.dir;
		this.dir = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("dir", oldValue, value);
		return (T) this;
	}

	/**
	 * List of modules containing themes.
	 */
	@ModelNodeBinding(detypedName = "modules")
	public List<String> modules() {
		return this.modules;
	}

	/**
	 * List of modules containing themes.
	 */
	@SuppressWarnings("unchecked")
	public T modules(java.util.List<String> value) {
		Object oldValue = this.modules;
		this.modules = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("modules", oldValue, value);
		return (T) this;
	}

	/**
	 * List of modules containing themes.
	 */
	@SuppressWarnings("unchecked")
	public T module(String value) {
		if (this.modules == null) {
			this.modules = new java.util.ArrayList<>();
		}
		this.modules.add(value);
		return (T) this;
	}

	/**
	 * List of modules containing themes.
	 */
	@SuppressWarnings("unchecked")
	public T modules(String... args) {
		modules(Arrays.asList(args));
		return (T) this;
	}

	/**
	 * Maximum time the browser should cache theme resources. A value of -1 will
	 * disable caching.
	 */
	@ModelNodeBinding(detypedName = "staticMaxAge")
	public Long staticmaxage() {
		return this.staticmaxage;
	}

	/**
	 * Maximum time the browser should cache theme resources. A value of -1 will
	 * disable caching.
	 */
	@SuppressWarnings("unchecked")
	public T staticmaxage(java.lang.Long value) {
		Object oldValue = this.staticmaxage;
		this.staticmaxage = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("staticmaxage", oldValue, value);
		return (T) this;
	}

	/**
	 * The welcome theme.
	 */
	@ModelNodeBinding(detypedName = "welcomeTheme")
	public String welcometheme() {
		return this.welcometheme;
	}

	/**
	 * The welcome theme.
	 */
	@SuppressWarnings("unchecked")
	public T welcometheme(java.lang.String value) {
		Object oldValue = this.welcometheme;
		this.welcometheme = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("welcometheme", oldValue, value);
		return (T) this;
	}
}