/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.wildfly.swarm.config.keycloak.server.Spi;
import org.wildfly.swarm.config.keycloak.server.SpiConsumer;
import org.wildfly.swarm.config.keycloak.server.SpiSupplier;
import org.wildfly.swarm.config.keycloak.server.Theme;
import org.wildfly.swarm.config.keycloak.server.ThemeConsumer;
import org.wildfly.swarm.config.keycloak.server.ThemeSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/subsystem=keycloak-server")
@ResourceType(value="subsystem")
@Implicit
public class KeycloakServer<T extends KeycloakServer<T>>
extends HashMap
implements Keyed {
    private String key = "keycloak-server";
    private PropertyChangeSupport pcs;
    private KeycloakServerResources subresources = new KeycloakServerResources();
    private String masterRealmName;
    private List<String> providers;
    private Long scheduledTaskInterval;
    private String webContext;

    public KeycloakServer() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public KeycloakServerResources subresources() {
        return this.subresources;
    }

    public T themes(List<Theme> value) {
        this.subresources.themes = value;
        return (T)this;
    }

    public T theme(Theme value) {
        this.subresources.themes.add(value);
        return (T)this;
    }

    public T theme(String childKey, ThemeConsumer consumer) {
        Theme child = new Theme(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.theme(child);
        return (T)this;
    }

    public T theme(String childKey) {
        this.theme(childKey, null);
        return (T)this;
    }

    public T theme(ThemeSupplier supplier) {
        this.theme(supplier.get());
        return (T)this;
    }

    public T spis(List<Spi> value) {
        this.subresources.spis = value;
        return (T)this;
    }

    public T spi(Spi value) {
        this.subresources.spis.add(value);
        return (T)this;
    }

    public T spi(String childKey, SpiConsumer consumer) {
        Spi child = new Spi(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.spi(child);
        return (T)this;
    }

    public T spi(String childKey) {
        this.spi(childKey, null);
        return (T)this;
    }

    public T spi(SpiSupplier supplier) {
        this.spi(supplier.get());
        return (T)this;
    }

    @ModelNodeBinding(detypedName="master-realm-name")
    public String masterRealmName() {
        return this.masterRealmName;
    }

    public T masterRealmName(String value) {
        String oldValue = this.masterRealmName;
        this.masterRealmName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("masterRealmName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="providers")
    public List<String> providers() {
        return this.providers;
    }

    public T providers(List<String> value) {
        List<String> oldValue = this.providers;
        this.providers = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("providers", oldValue, value);
        }
        return (T)this;
    }

    public T provider(String value) {
        if (this.providers == null) {
            this.providers = new ArrayList<String>();
        }
        this.providers.add(value);
        return (T)this;
    }

    public T providers(String ... args) {
        this.providers(Arrays.asList(args));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="scheduled-task-interval")
    public Long scheduledTaskInterval() {
        return this.scheduledTaskInterval;
    }

    public T scheduledTaskInterval(Long value) {
        Long oldValue = this.scheduledTaskInterval;
        this.scheduledTaskInterval = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("scheduledTaskInterval", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="web-context")
    public String webContext() {
        return this.webContext;
    }

    public T webContext(String value) {
        String oldValue = this.webContext;
        this.webContext = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("webContext", oldValue, value);
        }
        return (T)this;
    }

    public static class KeycloakServerResources {
        @SubresourceInfo(value="theme")
        private List<Theme> themes = new ArrayList<Theme>();
        @SubresourceInfo(value="spi")
        private List<Spi> spis = new ArrayList<Spi>();

        @Subresource
        public List<Theme> themes() {
            return this.themes;
        }

        public Theme theme(String key) {
            return this.themes.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<Spi> spis() {
            return this.spis;
        }

        public Spi spi(String key) {
            return this.spis.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

