/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.keycloak.server;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.wildfly.swarm.config.keycloak.server.spi.Provider;
import org.wildfly.swarm.config.keycloak.server.spi.ProviderConsumer;
import org.wildfly.swarm.config.keycloak.server.spi.ProviderSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/subsystem=keycloak-server/spi=*")
@ResourceType(value="spi")
public class Spi<T extends Spi<T>>
extends HashMap
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    private SpiResources subresources = new SpiResources();
    private String defaultProvider;

    public Spi(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public SpiResources subresources() {
        return this.subresources;
    }

    public T providers(List<Provider> value) {
        this.subresources.providers = value;
        return (T)this;
    }

    public T provider(Provider value) {
        this.subresources.providers.add(value);
        return (T)this;
    }

    public T provider(String childKey, ProviderConsumer consumer) {
        Provider child = new Provider(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.provider(child);
        return (T)this;
    }

    public T provider(String childKey) {
        this.provider(childKey, null);
        return (T)this;
    }

    public T provider(ProviderSupplier supplier) {
        this.provider(supplier.get());
        return (T)this;
    }

    @ModelNodeBinding(detypedName="default-provider")
    public String defaultProvider() {
        return this.defaultProvider;
    }

    public T defaultProvider(String value) {
        String oldValue = this.defaultProvider;
        this.defaultProvider = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("defaultProvider", oldValue, value);
        }
        return (T)this;
    }

    public static class SpiResources {
        @SubresourceInfo(value="provider")
        private List<Provider> providers = new ArrayList<Provider>();

        @Subresource
        public List<Provider> providers() {
            return this.providers;
        }

        public Provider provider(String key) {
            return this.providers.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

