package org.wildfly.swarm.config.keycloak.server;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.keycloak.server.spi.ProviderConsumer;
import org.wildfly.swarm.config.keycloak.server.spi.ProviderSupplier;
import org.wildfly.swarm.config.keycloak.server.spi.Provider;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * A Service Provider type.
 */
@Address("/subsystem=keycloak-server/spi=*")
@ResourceType("spi")
public class Spi<T extends Spi<T>> extends HashMap
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private SpiResources subresources = new SpiResources();
	private String defaultProvider;

	public Spi(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public SpiResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all Provider objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of Provider objects.
	 */
	@SuppressWarnings("unchecked")
	public T providers(java.util.List<Provider> value) {
		this.subresources.providers = value;
		return (T) this;
	}

	/**
	 * Add the Provider object to the list of subresources
	 * 
	 * @param value
	 *            The Provider to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T provider(Provider value) {
		this.subresources.providers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a Provider object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Provider resource
	 * @param config
	 *            The ProviderConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T provider(java.lang.String childKey, ProviderConsumer consumer) {
		Provider<? extends Provider> child = new Provider<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		provider(child);
		return (T) this;
	}

	/**
	 * Create and configure a Provider object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Provider resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T provider(java.lang.String childKey) {
		provider(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied Provider object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T provider(ProviderSupplier supplier) {
		provider(supplier.get());
		return (T) this;
	}

	/**
	 * Child mutators for Spi
	 */
	public static class SpiResources {
		/**
		 * A provider for the spi.
		 */
		@SubresourceInfo("provider")
		private List<Provider> providers = new java.util.ArrayList<>();

		/**
		 * Get the list of Provider resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<Provider> providers() {
			return this.providers;
		}

		public Provider provider(java.lang.String key) {
			return this.providers.stream().filter(e -> e.getKey().equals(key))
					.findFirst().orElse(null);
		}
	}

	/**
	 * The default provider for the spi.
	 */
	@ModelNodeBinding(detypedName = "default-provider")
	public String defaultProvider() {
		return this.defaultProvider;
	}

	/**
	 * The default provider for the spi.
	 */
	@SuppressWarnings("unchecked")
	public T defaultProvider(java.lang.String value) {
		Object oldValue = this.defaultProvider;
		this.defaultProvider = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("defaultProvider", oldValue, value);
		return (T) this;
	}
}