package org.wildfly.swarm.config;

import org.wildfly.swarm.config.KeycloakServer;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface KeycloakServerConsumer<T extends KeycloakServer<T>> {

	/**
	 * Configure a pre-constructed instance of KeycloakServer resource
	 * 
	 * @parameter Instance of KeycloakServer to configure
	 * @return nothing
	 */
	void accept(T value);

	default KeycloakServerConsumer<T> andThen(KeycloakServerConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}