/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.keycloak.server;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.wildfly.swarm.bootstrap.util.TempFileManager;
import org.wildfly.swarm.config.infinispan.CacheContainer;
import org.wildfly.swarm.config.infinispan.cache_container.TransactionComponent;
import org.wildfly.swarm.datasources.DatasourcesFraction;
import org.wildfly.swarm.infinispan.InfinispanFraction;
import org.wildfly.swarm.spi.api.Fraction;

public class KeycloakServerFraction
implements Fraction {
    public void postInitialize(Fraction.PostInitContext initContext) {
        DatasourcesFraction datasources;
        InfinispanFraction infinispan;
        CacheContainer cache;
        if (System.getProperty("jboss.server.config.dir") == null) {
            try {
                File dir = TempFileManager.INSTANCE.newTempDirectory("swarm-keycloak-config", ".d");
                System.setProperty("jboss.server.config.dir", dir.getAbsolutePath());
                Files.copy(this.getClass().getClassLoader().getResourceAsStream("keycloak-server.json"), dir.toPath().resolve("keycloak-server.json"), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if ((cache = (infinispan = (InfinispanFraction)initContext.fraction("infinispan")).subresources().cacheContainer("keycloak")) == null) {
            infinispan.cacheContainer("keycloak", c -> c.jndiName("infinispan/Keycloak").localCache("realms").localCache("users").localCache("sessions").localCache("offlineSessions").localCache("loginFailures").localCache("work").localCache("realmVersions", ca -> ca.transactionComponent(new TransactionComponent().mode(TransactionComponent.Mode.BATCH).locking(TransactionComponent.Locking.PESSIMISTIC))));
        }
        if ((datasources = (DatasourcesFraction)initContext.fraction("datasources")).subresources().dataSource("KeycloakDS") == null) {
            if (datasources.subresources().jdbcDriver("h2") == null) {
                datasources.jdbcDriver("h2", driver -> {
                    driver.driverModuleName("com.h2database.h2");
                    driver.moduleSlot("main");
                    driver.xaDatasourceClass("org.h2.jdbcx.JdbcDataSource");
                });
            }
            datasources.dataSource("KeycloakDS", ds -> {
                ds.jndiName("java:jboss/datasources/KeycloakDS");
                ds.useJavaContext(Boolean.valueOf(true));
                ds.connectionUrl("jdbc:h2:${wildfly.swarm.keycloak.server.db:./keycloak};AUTO_SERVER=TRUE");
                ds.driverName("h2");
                ds.userName("sa");
                ds.password("sa");
            });
        }
    }
}

