/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.keycloak.server.runtime;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.inject.Inject;
import org.wildfly.swarm.config.infinispan.CacheContainer;
import org.wildfly.swarm.config.infinispan.cache_container.EvictionComponent;
import org.wildfly.swarm.infinispan.InfinispanFraction;
import org.wildfly.swarm.spi.api.Customizer;
import org.wildfly.swarm.spi.runtime.annotations.Post;

@Post
@ApplicationScoped
public class KeycloakCacheCustomizer
implements Customizer {
    @Inject
    @Any
    private InfinispanFraction infinispan;

    public void customize() {
        CacheContainer cache = this.infinispan.subresources().cacheContainer("keycloak");
        if (cache == null) {
            this.infinispan.cacheContainer("keycloak", c -> c.jndiName("infinispan/Keycloak").localCache("realms", localCache -> localCache.evictionComponent(evict -> {
                evict.maxEntries(Long.valueOf(10000L));
                evict.strategy(EvictionComponent.Strategy.LRU);
            })).localCache("users", localCache -> localCache.evictionComponent(evict -> {
                evict.maxEntries(Long.valueOf(10000L));
                evict.strategy(EvictionComponent.Strategy.LRU);
            })).localCache("sessions").localCache("offlineSessions").localCache("loginFailures").localCache("work").localCache("authorization", localCache -> localCache.evictionComponent(evict -> {
                evict.strategy(EvictionComponent.Strategy.LRU);
                evict.maxEntries(Long.valueOf(100L));
            })).localCache("keys", localCache -> {
                localCache.evictionComponent(evict -> {
                    evict.strategy(EvictionComponent.Strategy.LRU);
                    evict.maxEntries(Long.valueOf(1000L));
                });
                localCache.expirationComponent(expire -> expire.maxIdle(Long.valueOf(3600000L)));
            }));
        }
    }
}

