/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.keycloak.server.runtime;

import java.io.File;
import java.net.URL;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ExplodedExporter;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.wildfly.swarm.bootstrap.util.TempFileManager;
import org.wildfly.swarm.keycloak.server.KeycloakServerFraction;
import org.wildfly.swarm.spi.api.Customizer;
import org.wildfly.swarm.spi.api.JARArchive;
import org.wildfly.swarm.spi.runtime.annotations.Post;

@Post
@ApplicationScoped
public class KeycloakThemesCustomizer
implements Customizer {
    @Inject
    KeycloakServerFraction keycloakServer;

    public void customize() {
        if (!this.keycloakServer.subresources().themes().isEmpty()) {
            return;
        }
        try {
            Module module = Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)"org.keycloak.keycloak-themes"));
            URL resource = module.getExportedResource("keycloak-themes.jar");
            System.err.println("themes.jar: " + resource);
            JARArchive themesArtifact = (JARArchive)ShrinkWrap.create(JARArchive.class);
            ((ZipImporter)themesArtifact.as(ZipImporter.class)).importFrom(resource.openStream());
            File root = TempFileManager.INSTANCE.newTempDirectory("keycloak-themes", ".d");
            File exportedDir = ((ExplodedExporter)themesArtifact.as(ExplodedExporter.class)).exportExplodedInto(root);
            File themeDir = new File(exportedDir, "theme");
            System.err.println("exported to " + exportedDir.getAbsolutePath());
            this.keycloakServer.theme("defaults", theme -> {
                theme.dir(themeDir.getAbsolutePath());
                theme.staticmaxage(Long.valueOf(2592000L));
                theme.cachethemes(Boolean.valueOf(true));
                theme.cachetemplates(Boolean.valueOf(true));
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

