/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.keycloak.server.runtime;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.inject.Inject;
import org.wildfly.swarm.datasources.DatasourcesFraction;
import org.wildfly.swarm.spi.api.Customizer;
import org.wildfly.swarm.spi.runtime.annotations.Post;

@Post
@ApplicationScoped
public class KeycloakDatasourceCustomizer
implements Customizer {
    @Inject
    @Any
    private DatasourcesFraction datasources;

    public void customize() {
        if (this.datasources.subresources().dataSource("KeycloakDS") == null) {
            if (this.datasources.subresources().jdbcDriver("h2") == null) {
                this.datasources.jdbcDriver("h2", driver -> {
                    driver.driverModuleName("com.h2database.h2");
                    driver.moduleSlot("main");
                    driver.xaDatasourceClass("org.h2.jdbcx.JdbcDataSource");
                });
            }
            this.datasources.dataSource("KeycloakDS", ds -> {
                ds.jndiName("java:jboss/datasources/KeycloakDS");
                ds.useJavaContext(Boolean.valueOf(true));
                ds.connectionUrl("jdbc:h2:${wildfly.swarm.keycloak.server.db:./keycloak};AUTO_SERVER=TRUE");
                ds.driverName("h2");
                ds.userName("sa");
                ds.password("sa");
            });
        }
    }
}

