/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.keycloak;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ByteArrayAsset;
import org.jboss.shrinkwrap.api.asset.NamedAsset;
import org.jboss.shrinkwrap.impl.base.ArchiveBase;
import org.jboss.shrinkwrap.impl.base.AssignableBase;
import org.jboss.shrinkwrap.impl.base.importer.zip.ZipImporterImpl;
import org.wildfly.swarm.container.JARArchive;
import org.wildfly.swarm.keycloak.Secured;
import org.wildfly.swarm.keycloak.SecuredWebXmlAsset;
import org.wildfly.swarm.keycloak.SecurityConstraint;

public class SecuredImpl
extends AssignableBase<ArchiveBase<?>>
implements Secured {
    private SecuredWebXmlAsset asset;

    public SecuredImpl(ArchiveBase<?> archive) {
        super(archive);
        String appArtifact;
        Node node = ((JARArchive)((ArchiveBase)this.getArchive()).as(JARArchive.class)).get("WEB-INF/web.xml");
        if (node == null) {
            this.asset = new SecuredWebXmlAsset();
            ((JARArchive)((ArchiveBase)this.getArchive()).as(JARArchive.class)).add((NamedAsset)this.asset);
        } else if (!(node.getAsset() instanceof SecuredWebXmlAsset)) {
            throw new RuntimeException("Secured may not be used when providing a custom WEB-INF/web.xml");
        }
        ((JARArchive)((ArchiveBase)this.getArchive()).as(JARArchive.class)).addModule("org.wildfly.swarm.keycloak", "runtime");
        ((JARArchive)((ArchiveBase)this.getArchive()).as(JARArchive.class)).addAsServiceProvider("io.undertow.servlet.ServletExtension", new String[]{"org.wildfly.swarm.keycloak.runtime.SecurityContextServletExtension"});
        InputStream keycloakJson = Thread.currentThread().getContextClassLoader().getResourceAsStream("keycloak.json");
        if (keycloakJson == null && (appArtifact = System.getProperty("swarm.app.artifact")) != null) {
            try (InputStream in = ClassLoader.getSystemClassLoader().getResourceAsStream("_bootstrap/" + appArtifact);){
                ZipImporterImpl importer = new ZipImporterImpl(archive);
                importer.importFrom(in);
                Node jsonNode = archive.get("keycloak.json");
                if (jsonNode == null) {
                    jsonNode = archive.get("WEB-INF/keycloak.json");
                }
                if (jsonNode != null && jsonNode.getAsset() != null) {
                    keycloakJson = jsonNode.getAsset().openStream();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (keycloakJson != null) {
            ((JARArchive)((ArchiveBase)this.getArchive()).as(JARArchive.class)).add(this.createAsset(keycloakJson), "WEB-INF/keycloak.json");
        }
    }

    @Override
    public SecurityConstraint protect() {
        return this.asset.protect();
    }

    @Override
    public SecurityConstraint protect(String urlPattern) {
        return this.asset.protect(urlPattern);
    }

    private Asset createAsset(InputStream in) {
        StringBuilder str = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                str.append(line).append("\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new ByteArrayAsset(str.toString().getBytes());
    }
}

