/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.keycloak.deployment;

import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.api.ThreadSetupHandler;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.undertow.OIDCUndertowHttpFacade;
import org.wildfly.swarm.keycloak.deployment.KeycloakSecurityContextAssociation;

class KeycloakThreadSetupHandler
implements ThreadSetupHandler {
    KeycloakThreadSetupHandler() {
    }

    public <T, C> ThreadSetupHandler.Action<T, C> create(final ThreadSetupHandler.Action<T, C> action) {
        return new ThreadSetupHandler.Action<T, C>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public T call(HttpServerExchange exchange, C context) throws Exception {
                if (exchange == null) {
                    return action.call(exchange, context);
                }
                KeycloakSecurityContext c = (KeycloakSecurityContext)exchange.getAttachment(OIDCUndertowHttpFacade.KEYCLOAK_SECURITY_CONTEXT_KEY);
                KeycloakSecurityContextAssociation.associate(c);
                try {
                    Object object = action.call(exchange, context);
                    return object;
                }
                finally {
                    KeycloakSecurityContextAssociation.disassociate();
                }
            }
        };
    }
}

