/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.keycloak.runtime;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wildfly.swarm.undertow.descriptors.SecurityConstraint;

class SecurityConstraintParser {
    private SecurityConstraintParser() {
    }

    static SecurityConstraint parse(String scAsString) {
        Matcher matcher = SecurityConstraintParser.getMatcher(scAsString, "url-pattern=(.*?)[,}]");
        SecurityConstraint sc = matcher.find() ? new SecurityConstraint(matcher.group(1)) : new SecurityConstraint();
        matcher = SecurityConstraintParser.getMatcher(scAsString, "methods=\\[(.*?)\\]");
        if (matcher.find()) {
            sc.withMethod(SecurityConstraintParser.trim(matcher.group(1).split(",")));
        }
        if ((matcher = SecurityConstraintParser.getMatcher(scAsString, "roles=\\[(.*?)\\]")).find()) {
            sc.withRole(SecurityConstraintParser.trim(matcher.group(1).split(",")));
        }
        return sc;
    }

    private static Matcher getMatcher(String scAsString, String exp) {
        Pattern pattern = Pattern.compile(exp);
        return pattern.matcher(scAsString);
    }

    private static String[] trim(String[] array) {
        String[] trimmed = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            trimmed[i] = array[i].trim();
        }
        return trimmed;
    }
}

