/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.keycloak.runtime;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ByteArrayAsset;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.wildfly.swarm.keycloak.Secured;
import org.wildfly.swarm.spi.api.ArchivePreparer;
import org.wildfly.swarm.spi.api.JARArchive;
import org.wildfly.swarm.spi.api.annotations.Configurable;
import org.wildfly.swarm.undertow.descriptors.SecurityConstraint;

@ApplicationScoped
public class SecuredArchivePreparer
implements ArchivePreparer {
    private static final Logger LOG = Logger.getLogger(SecuredArchivePreparer.class);
    @Configurable(value="swarm.keycloak.json.path")
    String keycloakJsonPath;
    @Configurable(value="swarm.keycloak.security.constraints")
    List<Map<String, Object>> securityConstraints;

    public void prepareArchive(Archive<?> archive) {
        InputStream keycloakJson = null;
        if (this.keycloakJsonPath != null) {
            keycloakJson = this.getKeycloakJson(this.keycloakJsonPath);
        }
        if (keycloakJson == null) {
            keycloakJson = this.getKeycloakJson();
        }
        if (keycloakJson != null) {
            archive.add(this.createAsset(keycloakJson), "WEB-INF/keycloak.json");
        }
        if (this.securityConstraints == null || this.securityConstraints.isEmpty()) {
            return;
        }
        Secured secured = (Secured)archive.as(Secured.class);
        this.securityConstraints.forEach(sc -> {
            SecurityConstraint securityConstraint = secured.protect(sc.getOrDefault("url-pattern", "/*"));
            sc.getOrDefault("methods", Collections.emptyList()).forEach(arg_0 -> ((SecurityConstraint)securityConstraint).withMethod(arg_0));
            sc.getOrDefault("roles", Collections.emptyList()).forEach(arg_0 -> ((SecurityConstraint)securityConstraint).withRole(arg_0));
        });
    }

    private InputStream getKeycloakJson(String path) {
        try {
            return Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]);
        }
        catch (IOException e) {
            LOG.warn((Object)String.format("Unable to get keycloak.json from '%s', fall back to get from classpath: %s", path, e));
            return null;
        }
    }

    private InputStream getKeycloakJson() {
        String appArtifact;
        InputStream keycloakJson = Thread.currentThread().getContextClassLoader().getResourceAsStream("keycloak.json");
        if (keycloakJson == null && (appArtifact = System.getProperty("swarm.app.artifact")) != null) {
            try (InputStream in = ClassLoader.getSystemClassLoader().getResourceAsStream("_bootstrap/" + appArtifact);){
                Archive tmpArchive = (Archive)ShrinkWrap.create(JARArchive.class);
                ((ZipImporter)tmpArchive.as(ZipImporter.class)).importFrom(in);
                Node jsonNode = tmpArchive.get("keycloak.json");
                if (jsonNode == null) {
                    jsonNode = tmpArchive.get("WEB-INF/keycloak.json");
                }
                if (jsonNode != null && jsonNode.getAsset() != null) {
                    keycloakJson = jsonNode.getAsset().openStream();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return keycloakJson;
    }

    private Asset createAsset(InputStream in) {
        StringBuilder str = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                str.append(line).append("\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new ByteArrayAsset(str.toString().getBytes());
    }
}

