/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.keycloak.runtime;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.inject.Inject;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ByteArrayAsset;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.spi.api.DeploymentProcessor;
import org.wildfly.swarm.spi.api.JARArchive;
import org.wildfly.swarm.spi.api.annotations.Configurable;
import org.wildfly.swarm.spi.runtime.annotations.DeploymentScoped;

@DeploymentScoped
public class SecuredArchivePreparer
implements DeploymentProcessor {
    private static final Logger LOG = Logger.getLogger(SecuredArchivePreparer.class);
    private final Archive<?> archive;
    @AttributeDocumentation(value="Path to keycloak.json configuration")
    @Configurable(value="swarm.keycloak.json.path")
    String keycloakJsonPath;

    @Inject
    public SecuredArchivePreparer(Archive archive) {
        this.archive = archive;
    }

    public void process() throws IOException {
        InputStream keycloakJson = null;
        URI keycloakJsonUri = null;
        if (this.keycloakJsonPath != null) {
            keycloakJsonUri = URI.create(this.keycloakJsonPath);
            keycloakJson = this.getKeycloakJsonFromCustomPath(keycloakJsonUri);
        }
        if (keycloakJson == null) {
            keycloakJson = this.getKeycloakJson(keycloakJsonUri);
        }
        if (keycloakJson != null) {
            this.archive.add(this.createAsset(keycloakJson), "WEB-INF/keycloak.json");
        }
    }

    private InputStream getKeycloakJsonFromCustomPath(URI keycloakJsonUri) {
        if ("classpath".equals(keycloakJsonUri.getScheme())) {
            return null;
        }
        try {
            Path path = keycloakJsonUri.getScheme() != null ? Paths.get(keycloakJsonUri) : Paths.get(this.keycloakJsonPath, new String[0]);
            return Files.newInputStream(path, new OpenOption[0]);
        }
        catch (IOException e) {
            LOG.warn((Object)String.format("Unable to get keycloak.json from '%s', fall back to get from classpath: %s", this.keycloakJsonPath, e));
            return null;
        }
    }

    private InputStream getKeycloakJson(URI keycloakJsonUri) {
        String appArtifact;
        String resourceName = keycloakJsonUri != null && "classpath".equals(keycloakJsonUri.getScheme()) ? keycloakJsonUri.getSchemeSpecificPart() : "keycloak.json";
        InputStream keycloakJson = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);
        if (keycloakJson == null && (appArtifact = System.getProperty("swarm.app.artifact")) != null) {
            try (InputStream in = ClassLoader.getSystemClassLoader().getResourceAsStream("_bootstrap/" + appArtifact);){
                Archive tmpArchive = (Archive)ShrinkWrap.create(JARArchive.class);
                ((ZipImporter)tmpArchive.as(ZipImporter.class)).importFrom(in);
                Node jsonNode = tmpArchive.get(resourceName);
                if (jsonNode == null) {
                    jsonNode = SecuredArchivePreparer.getKeycloakJsonNodeFromWebInf(tmpArchive, resourceName, true);
                }
                if (jsonNode == null) {
                    jsonNode = SecuredArchivePreparer.getKeycloakJsonNodeFromWebInf(tmpArchive, resourceName, false);
                }
                if (jsonNode != null && jsonNode.getAsset() != null) {
                    keycloakJson = jsonNode.getAsset().openStream();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return keycloakJson;
    }

    private static Node getKeycloakJsonNodeFromWebInf(Archive<?> tmpArchive, String resourceName, boolean useForwardSlash) {
        Node jsonNode;
        String webInfPath;
        String string = webInfPath = useForwardSlash ? "/WEB-INF" : "WEB-INF";
        if (!resourceName.startsWith("/")) {
            resourceName = "/" + resourceName;
        }
        if ((jsonNode = tmpArchive.get(webInfPath + resourceName)) == null) {
            jsonNode = tmpArchive.get(webInfPath + "/classes" + resourceName);
        }
        return jsonNode;
    }

    private Asset createAsset(InputStream in) throws IOException {
        StringBuilder str = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                str.append(line).append("\n");
            }
        }
        return new ByteArrayAsset(str.toString().getBytes());
    }
}

