/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.logging;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.wildfly.swarm.config.Logging;
import org.wildfly.swarm.config.logging.AsyncHandler;
import org.wildfly.swarm.config.logging.ConsoleHandler;
import org.wildfly.swarm.config.logging.CustomFormatter;
import org.wildfly.swarm.config.logging.CustomHandler;
import org.wildfly.swarm.config.logging.FileHandler;
import org.wildfly.swarm.config.logging.Level;
import org.wildfly.swarm.config.logging.PatternFormatter;
import org.wildfly.swarm.config.logging.RootLogger;
import org.wildfly.swarm.config.logging.SyslogHandler;
import org.wildfly.swarm.spi.api.Fraction;

public class LoggingFraction
extends Logging<LoggingFraction>
implements Fraction {
    public static final String CONSOLE = "CONSOLE";
    public static final String PATTERN = "PATTERN";
    public static final String COLOR_PATTERN = "COLOR_PATTERN";

    public static LoggingFraction createTraceLoggingFraction() {
        return LoggingFraction.createDefaultLoggingFraction(Level.TRACE);
    }

    public static LoggingFraction createDebugLoggingFraction() {
        return LoggingFraction.createDefaultLoggingFraction(Level.DEBUG);
    }

    public static LoggingFraction createErrorLoggingFraction() {
        return LoggingFraction.createDefaultLoggingFraction(Level.ERROR);
    }

    public static LoggingFraction createDefaultLoggingFraction() {
        return LoggingFraction.createDefaultLoggingFraction(Level.INFO);
    }

    public static LoggingFraction createDefaultLoggingFraction(Level level) {
        return new LoggingFraction().defaultColorFormatter().consoleHandler(level, COLOR_PATTERN).rootLogger(level, CONSOLE);
    }

    public LoggingFraction defaultFormatter() {
        return this.formatter(PATTERN, "%d{yyyy-MM-dd HH:mm:ss,SSS} %-5p [%c] (%t) %s%e%n");
    }

    public LoggingFraction defaultColorFormatter() {
        return this.formatter(COLOR_PATTERN, "%d{yyyy-MM-dd HH:mm:ss,SSS} %-5p [%c] (%t) %s%e%n");
    }

    public LoggingFraction formatter(String name, String pattern) {
        this.patternFormatter(new PatternFormatter(name).pattern(pattern));
        return this;
    }

    public LoggingFraction customFormatter(String name, String module, String className) {
        return this.customFormatter(name, module, className, null);
    }

    public LoggingFraction customFormatter(String name, String module, String className, Properties properties) {
        HashMap<String, String> formatterProperties = new HashMap<String, String>();
        Enumeration<?> names = properties.propertyNames();
        while (names.hasMoreElements()) {
            String nextElement = (String)names.nextElement();
            formatterProperties.put(nextElement, properties.getProperty(nextElement));
        }
        this.customFormatter(new CustomFormatter(name).module(module).attributeClass(className).properties(formatterProperties));
        return this;
    }

    public List<PatternFormatter> patternFormatters() {
        return this.subresources().patternFormatters();
    }

    public List<CustomFormatter> customFormatters() {
        return this.subresources().customFormatters();
    }

    public LoggingFraction consoleHandler(Level level, String formatter) {
        this.consoleHandler(new ConsoleHandler(CONSOLE).level(level).namedFormatter(formatter));
        return this;
    }

    public List<ConsoleHandler> consoleHandlers() {
        return this.subresources().consoleHandlers();
    }

    public LoggingFraction fileHandler(String name, String path, Level level, String formatter) {
        HashMap<String, String> fileProperties = new HashMap<String, String>();
        fileProperties.put("path", path);
        fileProperties.put("relative-to", "jboss.server.log.dir");
        this.fileHandler(new FileHandler(name).level(level).formatter(formatter).file(fileProperties));
        return this;
    }

    public List<FileHandler> fileHandlers() {
        return this.subresources().fileHandlers();
    }

    public LoggingFraction customHandler(String name, String module, String className, Properties properties, String formatter) {
        HashMap<String, String> handlerProperties = new HashMap<String, String>();
        Enumeration<?> names = properties.propertyNames();
        while (names.hasMoreElements()) {
            String nextElement = (String)names.nextElement();
            handlerProperties.put(nextElement, properties.getProperty(nextElement));
        }
        this.customHandler(new CustomHandler(name).module(module).attributeClass(className).formatter(formatter).properties(handlerProperties));
        return this;
    }

    public List<CustomHandler> customHandlers() {
        return this.subresources().customHandlers();
    }

    public List<AsyncHandler> asyncHandlers() {
        return this.subresources().asyncHandlers();
    }

    public List<SyslogHandler> syslogHandlers() {
        return this.subresources().syslogHandlers();
    }

    public LoggingFraction rootLogger(Level level, String ... handlers) {
        this.rootLogger(new RootLogger().level(level).handlers(handlers));
        return this;
    }
}

