/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.logging.runtime;

import java.util.List;
import org.jboss.dmr.ModelNode;
import org.wildfly.swarm.bootstrap.logging.InitialLoggerManager;
import org.wildfly.swarm.bootstrap.logging.LevelNode;
import org.wildfly.swarm.config.logging.Level;
import org.wildfly.swarm.container.Fraction;
import org.wildfly.swarm.container.runtime.MarshallingServerConfiguration;
import org.wildfly.swarm.logging.LoggingFraction;

public class LoggingConfiguration
extends MarshallingServerConfiguration<LoggingFraction> {
    public static final String EXTENSION_MODULE = "org.jboss.as.logging";

    public LoggingConfiguration() {
        super(LoggingFraction.class, EXTENSION_MODULE);
    }

    public LoggingFraction defaultFraction() {
        String prop = System.getProperty("swarm.logging");
        if (prop != null) {
            if ((prop = prop.trim().toLowerCase()).equals("debug")) {
                return LoggingFraction.createDebugLoggingFraction();
            }
            if (prop.equals("trace")) {
                return LoggingFraction.createTraceLoggingFraction();
            }
        }
        return LoggingFraction.createDefaultLoggingFraction();
    }

    public List<ModelNode> getList(LoggingFraction fraction) throws Exception {
        if (fraction == null) {
            fraction = this.defaultFraction();
        }
        LevelNode root = InitialLoggerManager.INSTANCE.getRoot();
        this.apply(root, fraction);
        return super.getList((Fraction)fraction);
    }

    private void apply(LevelNode node, LoggingFraction fraction) {
        if (!node.getName().equals("")) {
            fraction.logger(node.getName(), l -> l.level(Level.valueOf((String)node.getLevel().toString())));
        }
        for (LevelNode each : node.getChildren()) {
            this.apply(each, fraction);
        }
    }
}

